/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;

@Listener(observation=Listener.Observation.POST)
final class SegmentListener {
    private final AdvancedCache<?, ?> cache;
    private final Consumer<IntSet> segmentDeleted;
    private final Address address;
    private final BlockingManager blockingManager;

    SegmentListener(AdvancedCache<?, ?> cache, Consumer<IntSet> segmentsDeleted, BlockingManager blockingManager) {
        this.cache = cache;
        this.segmentDeleted = segmentsDeleted;
        this.address = cache.getRpcManager().getAddress();
        this.blockingManager = blockingManager;
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return CompletableFutures.completedNull();
        }
        ConsistentHash newWriteCh = event.getWriteConsistentHashAtEnd();
        LocalizedCacheTopology cacheTopology = this.cache.getDistributionManager().getCacheTopology();
        boolean isMember = cacheTopology.getMembers().contains(this.address);
        if (!isMember) {
            return CompletableFutures.completedNull();
        }
        int numSegments = newWriteCh.getNumSegments();
        IntSet removedSegments = IntSets.mutableEmptySet((int)numSegments);
        IntSet newSegments = IntSets.from((Set)newWriteCh.getSegmentsForOwner(this.address));
        for (int i = 0; i < numSegments; ++i) {
            if (newSegments.contains(i)) continue;
            removedSegments.set(i);
        }
        if (removedSegments.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        return this.blockingManager.runBlocking(() -> this.segmentDeleted.accept(removedSegments), (Object)this);
    }
}

