/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.api.annotations.indexing.option.TermVector;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class FieldMapping {
    private final String name;
    private final FieldDescriptor fieldDescriptor;
    private final boolean searchable;
    private final boolean projectable;
    private final boolean aggregable;
    private final boolean sortable;
    private final String analyzer;
    private final String normalizer;
    private final String indexNullAs;
    private final Boolean norms;
    private final String searchAnalyzer;
    private final TermVector termVector;
    private final Integer decimalScale;
    private final Integer includeDepth;
    private final Structure structure;
    private volatile boolean isInitialized = false;
    private Object indexNullAsObj;

    public FieldMapping(String name, boolean searchable, boolean projectable, boolean aggregable, boolean sortable, String analyzer, String normalizer, String indexNullAs, FieldDescriptor fieldDescriptor) {
        this(name, searchable, projectable, aggregable, sortable, analyzer, normalizer, indexNullAs, null, null, null, null, 3, null, fieldDescriptor);
    }

    public FieldMapping(String name, Boolean searchable, Boolean projectable, Boolean aggregable, Boolean sortable, String analyzer, String normalizer, String indexNullAs, Boolean norms, String searchAnalyzer, TermVector termVector, Integer decimalScale, Integer includeDepth, Structure structure, FieldDescriptor fieldDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException("fieldDescriptor argument cannot be null");
        }
        this.name = name;
        this.fieldDescriptor = fieldDescriptor;
        this.searchable = searchable;
        this.projectable = projectable;
        this.aggregable = aggregable;
        this.sortable = sortable;
        this.analyzer = analyzer;
        this.normalizer = normalizer;
        this.indexNullAs = indexNullAs;
        this.norms = norms;
        this.searchAnalyzer = searchAnalyzer;
        this.termVector = termVector;
        this.decimalScale = decimalScale;
        this.includeDepth = includeDepth;
        this.structure = structure;
    }

    public String name() {
        return this.name;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public boolean projectable() {
        return this.projectable;
    }

    public boolean aggregable() {
        return this.aggregable;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public String normalizer() {
        return this.normalizer;
    }

    public boolean analyzed() {
        return this.analyzer != null;
    }

    public boolean normalized() {
        return this.normalizer != null;
    }

    public Object indexNullAs() {
        this.init();
        return this.indexNullAsObj;
    }

    public Boolean norms() {
        return this.norms;
    }

    public String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public TermVector termVector() {
        return this.termVector;
    }

    public Integer decimalScale() {
        return this.decimalScale;
    }

    public Integer includeDepth() {
        return this.includeDepth;
    }

    public Structure structure() {
        return this.structure;
    }

    private void init() {
        if (!this.isInitialized) {
            if (this.fieldDescriptor.getType() == null) {
                throw new IllegalStateException("FieldDescriptors are not fully initialised!");
            }
            this.indexNullAsObj = this.parseIndexNullAs();
            this.isInitialized = true;
        }
    }

    public Object parseIndexNullAs() {
        if (this.indexNullAs != null) {
            switch (this.fieldDescriptor.getType()) {
                case DOUBLE: {
                    return Double.parseDouble(this.indexNullAs);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(this.indexNullAs));
                }
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: 
                case SINT64: {
                    return Long.parseLong(this.indexNullAs);
                }
                case INT32: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SINT32: {
                    return Integer.parseInt(this.indexNullAs);
                }
                case ENUM: {
                    EnumValueDescriptor enumVal = this.fieldDescriptor.getEnumType().findValueByName(this.indexNullAs);
                    if (enumVal == null) {
                        throw new IllegalArgumentException("Enum value not found : " + this.indexNullAs);
                    }
                    return enumVal.getNumber();
                }
                case BOOL: {
                    return Boolean.valueOf(this.indexNullAs);
                }
            }
        }
        return this.indexNullAs;
    }

    public String toString() {
        return "FieldMapping{name='" + this.name + "', fieldDescriptor=" + String.valueOf(this.fieldDescriptor) + ", searchable=" + this.searchable + ", projectable=" + this.projectable + ", aggregable=" + this.aggregable + ", sortable=" + this.sortable + ", analyzer='" + this.analyzer + "', normalizer='" + this.normalizer + "', indexNullAs='" + this.indexNullAs + "', norms=" + this.norms + ", searchAnalyzer='" + this.searchAnalyzer + "', termVector=" + String.valueOf(this.termVector) + ", decimalScale=" + this.decimalScale + ", includeDepth=" + this.includeDepth + ", structure=" + String.valueOf(this.structure) + "}";
    }
}

