/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.util.DomainWildcardMappingBuilder;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import org.infinispan.server.core.utils.SslUtils;

public class NettyChannelInitializer<A extends ProtocolServerConfiguration>
implements NettyInitializer {
    protected final ProtocolServer<A> server;
    protected final NettyTransport transport;
    protected final ChannelOutboundHandler encoder;
    protected final ChannelInboundHandler decoder;
    private final AccessControlFilter ipRulesHandler;
    private final StatsChannelHandler statsHandler;

    public NettyChannelInitializer(ProtocolServer<A> server, NettyTransport transport, ChannelOutboundHandler encoder, ChannelInboundHandler decoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
        this.decoder = decoder;
        this.statsHandler = transport != null ? new StatsChannelHandler(transport) : null;
        this.ipRulesHandler = new AccessControlFilter<A>(server.getConfiguration());
    }

    @Override
    public void initializeChannel(Channel ch) throws Exception {
        SslConfiguration ssl;
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("iprules", (ChannelHandler)this.ipRulesHandler);
        if (this.statsHandler != null) {
            pipeline.addLast("stats", (ChannelHandler)this.statsHandler);
        }
        if ((ssl = ((ProtocolServerConfiguration)((Object)this.server.getConfiguration())).ssl()).enabled()) {
            ApplicationProtocolConfig alpnConfig = this.getAlpnConfiguration();
            JdkSslContext defaultNettySslContext = SslUtils.createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"), alpnConfig);
            DomainWildcardMappingBuilder domainMappingBuilder = new DomainWildcardMappingBuilder((Object)defaultNettySslContext);
            ssl.sniDomainsConfiguration().forEach((k, v) -> {
                if (!"*".equals(k)) {
                    domainMappingBuilder.add(k, (Object)SslUtils.createNettySslContext(ssl, v, alpnConfig));
                }
            });
            pipeline.addLast("sni", (ChannelHandler)new SniHandler(domainMappingBuilder.build()));
        }
        if (this.decoder != null) {
            pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        }
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        return null;
    }
}

