/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.commons.util.SaslUtils;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.SubjectSaslServer;
import org.infinispan.server.core.security.external.ExternalSaslServerFactory;

public interface ServerAuthenticationProvider {
    @Deprecated(forRemoval=true)
    default public AuthorizingCallbackHandler getCallbackHandler(String mechanismName, Map<String, String> mechanismProperties) {
        return null;
    }

    default public SaslServer createSaslServer(String mechanism, List<Principal> principals, String protocol, String serverName, Map<String, String> props) throws SaslException {
        AuthorizingCallbackHandler callbackHandler = this.getCallbackHandler(mechanism, props);
        if ("EXTERNAL".equals(mechanism)) {
            for (Principal principal : principals) {
                if (!(principal instanceof X500Principal)) continue;
                ExternalSaslServerFactory factory = new ExternalSaslServerFactory((X500Principal)principal);
                SaslServer saslServer = factory.createSaslServer(mechanism, protocol, serverName, props, (Callback[] callbacks) -> {
                    if (callbackHandler != null) {
                        callbackHandler.handle(callbacks);
                    }
                });
                return new SubjectSaslServer(saslServer, principals, callbackHandler);
            }
            throw new IllegalStateException("EXTERNAL mech requires X500Principal");
        }
        for (SaslServerFactory factory : SaslUtils.getSaslServerFactories((ClassLoader)this.getClass().getClassLoader(), null, (boolean)true)) {
            SaslServer saslServer;
            if (factory == null || (saslServer = factory.createSaslServer(mechanism, protocol, serverName, props, (Callback[] callbacks) -> {
                if (callbackHandler != null) {
                    callbackHandler.handle(callbacks);
                }
            })) == null) continue;
            return new SubjectSaslServer(saslServer, principals, callbackHandler);
        }
        return null;
    }
}

