/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import java.util.List;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolDetector;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.AccessControlFilter;

public abstract class MagicByteDetector
extends ProtocolDetector {
    private final byte magicByte;

    protected MagicByteDetector(AbstractProtocolServer<?> server, byte magicByte) {
        super(server);
        this.magicByte = magicByte;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 1) {
            return;
        }
        byte b = in.getByte(in.readerIndex());
        if (b == this.magicByte) {
            this.trimPipeline(ctx);
            ctx.pipeline().addLast(new ChannelHandler[]{this.getInitializer()});
            Log.SERVER.tracef("Detected %s connection %s", this.getName(), ctx);
            ctx.fireChannelRegistered();
            ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    protected ChannelInitializer<Channel> getInitializer() {
        return this.server.getInitializer();
    }
}

