/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.channel.Channel;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.memcached.MemcachedDecoder;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

class ResponseEntry
implements BiConsumer<Object, Throwable>,
Runnable {
    volatile Object response;
    volatile Throwable throwable;
    CompletionStage<Void> responseSent;
    final MemcachedDecoder decoder;
    final Channel ch;

    ResponseEntry(MemcachedDecoder decoder, Channel ch) {
        this.decoder = decoder;
        this.ch = ch;
    }

    void queueResponse(CompletionStage<Object> operationResponse) {
        assert (this.ch.eventLoop().inEventLoop());
        AggregateCompletionStage all = CompletionStages.aggregateCompletionStage();
        if (this.decoder.lastResponse != null) {
            all.dependsOn(this.decoder.lastResponse.responseSent);
        }
        all.dependsOn(operationResponse.whenComplete(this));
        this.responseSent = all.freeze().exceptionally(CompletableFutures.toNullFunction()).thenRunAsync(this, (Executor)this.ch.eventLoop());
        this.decoder.lastResponse = this;
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        this.response = response;
        this.throwable = throwable;
    }

    @Override
    public void run() {
        this.decoder.writeResponseOrThrowable(this.ch, this.response, this.throwable);
    }
}

