/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.cluster.CLUSTER;

public class SHARDS
extends RespCommand
implements Resp3Command {
    @GuardedBy(value="this")
    private CompletionStage<CharSequence> lastExecution = null;
    @GuardedBy(value="this")
    private ConsistentHash lastAcceptedHash = null;

    public SHARDS() {
        super(2, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        AdvancedCache<byte[], byte[]> respCache = handler.cache();
        DistributionManager dm = respCache.getDistributionManager();
        if (dm == null) {
            RespErrorUtil.customError("This instance has cluster support disabled", handler.allocator());
            return handler.myStage();
        }
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash hash = topology.getCurrentCH();
        if (hash == null) {
            RespErrorUtil.customError("No consistent hash available", handler.allocator());
            return handler.myStage();
        }
        SHARDS sHARDS = this;
        synchronized (sHARDS) {
            if (!hash.equals((Object)this.lastAcceptedHash)) {
                this.lastExecution = SHARDS.readShardsInformation(hash, SecurityActions.getClusterExecutor(respCache), handler.respServer().segmentSlotRelation().slotWidth());
                this.lastAcceptedHash = hash;
            }
        }
        return handler.stageToReturn(this.lastExecution, ctx, ByteBufferUtils::stringToByteBuf);
    }

    private static CompletionStage<CharSequence> readShardsInformation(ConsistentHash hash, ClusterExecutor executor, int slotWidth) {
        HashMap<List, IntSet> segmentOwners = new HashMap<List, IntSet>();
        for (int i = 0; i < hash.getNumSegments(); ++i) {
            segmentOwners.computeIfAbsent(hash.locateOwnersForSegment(i), ignore -> IntSets.mutableEmptySet((int)hash.getNumSegments())).add(i);
        }
        return SHARDS.readNodeInformation(hash.getMembers(), executor).thenApply(information -> {
            StringBuilder response = new StringBuilder();
            response.append('*').append(segmentOwners.size()).append("\r\n");
            for (Map.Entry entry : segmentOwners.entrySet()) {
                List addresses = (List)entry.getKey();
                String leader = (String)information.get(addresses.get(0));
                if (leader == null) {
                    log.debugf("Not found information for leader: %s", addresses.get(0));
                    String name = ((Address)addresses.get(0)).toString();
                    StringBuilder sb = new StringBuilder();
                    SHARDS.createNodeSerialized(sb, name, name, 0, "loading");
                    leader = sb.toString();
                }
                ArrayList<String> replicas = null;
                if (addresses.size() > 1) {
                    replicas = new ArrayList<String>();
                    for (int i = 1; i < addresses.size(); ++i) {
                        String replica = (String)information.get(addresses.get(i));
                        if (replica == null) {
                            String name = ((Address)addresses.get(i)).toString();
                            StringBuilder sb = new StringBuilder();
                            SHARDS.createNodeSerialized(sb, name, name, 0, "loading");
                            replica = sb.toString();
                        }
                        replicas.add(replica);
                    }
                }
                SHARDS.serialize(response, leader, replicas, (IntSet)entry.getValue(), slotWidth);
            }
            return response;
        });
    }

    private static CompletionStage<Map<Address, String>> readNodeInformation(List<Address> members, ClusterExecutor executor) {
        ConcurrentHashMap responses = new ConcurrentHashMap(members.size());
        return executor.filterTargets(members).submitConsumer(SHARDS::readLocalNodeInformation, (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            responses.put(address, res);
        }).thenApply(ignore -> responses);
    }

    private static String readLocalNodeInformation(EmbeddedCacheManager ecm) {
        CacheManagerInfo manager = ecm.getCacheManagerInfo();
        String name = manager.getNodeName();
        Address address = CLUSTER.findPhysicalAddress(ecm);
        int port = CLUSTER.findPort(address);
        String addressString = address != null ? CLUSTER.getOnlyIp(address) : ecm.getCacheManagerInfo().getNodeAddress();
        StringBuilder sb = new StringBuilder();
        SHARDS.createNodeSerialized(sb, name, addressString, port, "online");
        return sb.toString();
    }

    private static void createNodeSerialized(StringBuilder sb, String name, String address, int port, String health) {
        sb.append("*14\r\n");
        sb.append("$2\r\n").append("id\r\n");
        sb.append("$").append(name.length()).append("\r\n").append(name).append("\r\n");
        sb.append("$4\r\n").append("port\r\n");
        sb.append(":").append(port).append("\r\n");
        sb.append("$2\r\n").append("ip\r\n");
        sb.append("$").append(address.length()).append("\r\n").append(address).append("\r\n");
        sb.append("$8\r\n").append("endpoint\r\n");
        sb.append("$").append(address.length()).append("\r\n").append(address).append("\r\n");
        sb.append("$18\r\n").append("replication-offset\r\n");
        sb.append(":0\r\n");
        sb.append("$6\r\n").append("health\r\n");
        sb.append("$").append(health.length()).append("\r\n").append(health).append("\r\n");
    }

    private static void serialize(StringBuilder output, String leader, List<String> replicas, IntSet ranges, int slotWidth) {
        output.append("*4\r\n");
        int segmentCount = 0;
        StringBuilder segments = new StringBuilder();
        int i = ranges.nextSetBit(0);
        while (i >= 0) {
            int runStart = i;
            while (ranges.contains(i + 1)) {
                ++i;
            }
            segments.append(":").append(runStart * slotWidth).append("\r\n");
            int endSlot = (i - 1) * slotWidth;
            if (endSlot > 16384) {
                endSlot = 16383;
            }
            segments.append(":").append(endSlot).append("\r\n");
            ++segmentCount;
            i = ranges.nextSetBit(i + 1);
        }
        output.append("$5\r\n").append("slots\r\n");
        output.append("*").append(segmentCount * 2).append("\r\n").append((CharSequence)segments);
        output.append("$5\r\n").append("nodes\r\n");
        output.append("*").append(replicas == null || replicas.isEmpty() ? 1 : replicas.size() + 1).append("\r\n");
        if (leader != null) {
            output.append(leader).append("$4\r\nrole\r\n$6\r\nmaster\r\n");
        } else {
            output.append("_\r\n");
        }
        if (replicas != null) {
            for (String replica : replicas) {
                output.append(replica).append("$4\r\nrole\r\n$7\r\nreplica\r\n");
            }
        }
    }
}

