/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;
import org.infinispan.util.function.SerializableFunction;

public class SLOTS
extends RespCommand
implements Resp3Command {
    @GuardedBy(value="this")
    private CompletionStage<CharSequence> lastExecution = null;
    @GuardedBy(value="this")
    private ConsistentHash lastAcceptedHash = null;

    public SLOTS() {
        super(2, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        AdvancedCache<byte[], byte[]> respCache = handler.cache();
        DistributionManager dm = respCache.getDistributionManager();
        if (dm == null) {
            RespErrorUtil.customError("This instance has cluster support disabled", handler.allocator());
            return handler.myStage();
        }
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash hash = topology.getCurrentCH();
        if (hash == null) {
            RespErrorUtil.customError("No consistent hash available", handler.allocator());
            return handler.myStage();
        }
        SLOTS sLOTS = this;
        synchronized (sLOTS) {
            if (!hash.equals((Object)this.lastAcceptedHash)) {
                this.lastExecution = SLOTS.getSlotsInformation(handler, hash);
                this.lastAcceptedHash = hash;
            }
        }
        return handler.stageToReturn(this.lastExecution, ctx, ByteBufferUtils::stringToByteBuf);
    }

    private static CompletionStage<CharSequence> getSlotsInformation(Resp3Handler handler, ConsistentHash hash) {
        return SLOTS.requestNodesNetworkInformation(hash.getMembers(), handler).thenApply(information -> {
            StringBuilder builder = new StringBuilder();
            int size = 0;
            SegmentSlotRelation ssr = handler.respServer().segmentSlotRelation();
            int previousOwnedSegment = -1;
            List ownersForSegment = null;
            int slotWidth = ssr.slotWidth();
            int totalSegmentCount = hash.getNumSegments();
            for (int i = 0; i < totalSegmentCount; ++i) {
                List currentOwners = hash.locateOwnersForSegment(i);
                if (currentOwners.equals(ownersForSegment) && i != totalSegmentCount - 1) continue;
                if (ownersForSegment != null) {
                    builder.append('*').append(2 + ownersForSegment.size()).append("\r\n");
                    int start = previousOwnedSegment * slotWidth;
                    int end = i * slotWidth - 1;
                    builder.append(':').append(start).append("\r\n");
                    builder.append(':').append(end).append("\r\n");
                    for (Address owner : ownersForSegment) {
                        String info = (String)information.get(owner);
                        builder.append(info);
                    }
                    ++size;
                }
                ownersForSegment = currentOwners;
                previousOwnedSegment = i;
            }
            return "*" + size + "\r\n" + String.valueOf(builder);
        });
    }

    private static CompletionStage<Map<Address, String>> requestNodesNetworkInformation(List<Address> members, Resp3Handler handler) {
        ConcurrentHashMap responses = new ConcurrentHashMap(members.size());
        ClusterExecutor executor = SecurityActions.getClusterExecutor(handler.cache());
        String name = handler.respServer().getQualifiedName();
        return executor.filterTargets(members).submitConsumer((SerializableFunction & Serializable)e -> SLOTS.readLocalInformation(name, e), (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            responses.put(address, res);
        }).thenApply(ignore -> responses);
    }

    private static String readLocalInformation(String serverName, EmbeddedCacheManager ecm) {
        StringBuilder sb = new StringBuilder();
        ComponentRef ref = ((BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm).getComponent(BasicComponentRegistry.class)).getComponent(serverName, RespServer.class);
        if (ref == null) {
            return "_\r\n";
        }
        sb.append("*4\r\n");
        RespServer server = (RespServer)((Object)ref.running());
        CacheManagerInfo info = ecm.getCacheManagerInfo();
        sb.append('$').append(server.getHost().length()).append("\r\n").append(server.getHost()).append("\r\n");
        sb.append(':').append(server.getPort()).append("\r\n");
        sb.append('$').append(info.getNodeName().length()).append("\r\n").append(info.getNodeName()).append("\r\n");
        NettyTransport transport = server.getTransport();
        if (transport != null) {
            String host = transport.getHostName();
            sb.append("*1\r\n").append('$').append(host.length()).append("\r\n").append(host).append("\r\n");
        } else {
            sb.append("_\r\n");
        }
        return sb.toString();
    }
}

