/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.hash;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespConstants;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;

public class HRANDFIELD
extends RespCommand
implements Resp3Command {
    private static final byte[] WITH_VALUES = "WITHVALUES".getBytes(StandardCharsets.US_ASCII);

    public HRANDFIELD() {
        super(-2, 1, 1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        int count = 1;
        boolean countDefined = false;
        if (arguments.size() > 1) {
            count = ArgumentUtils.toInt(arguments.get(1));
            countDefined = true;
        }
        if (count == 0) {
            ByteBufferUtils.bytesToResult(Collections.emptyList(), handler.allocator());
            return handler.myStage();
        }
        boolean withValues = false;
        if (arguments.size() > 2) {
            if (!Util.isAsciiBytesEquals(WITH_VALUES, arguments.get(2))) {
                RespErrorUtil.syntaxError(handler.allocator());
                return handler.myStage();
            }
            withValues = true;
        }
        EmbeddedMultimapPairCache<byte[], byte[], byte[]> multimap = handler.getHashMapMultimap();
        BiConsumer<Map<byte[], byte[]>, ByteBufPool> consumer = this.consumeResponse(count, withValues, countDefined);
        return handler.stageToReturn(multimap.subSelect((Object)key, Math.abs(count)), ctx, consumer);
    }

    private BiConsumer<Map<byte[], byte[]>, ByteBufPool> consumeResponse(int count, boolean withValues, boolean countDefined) {
        return (res, alloc) -> {
            if (res == null) {
                if (countDefined) {
                    Consumers.GET_ARRAY_BICONSUMER.accept(Collections.emptyList(), (ByteBufPool)alloc);
                } else {
                    alloc.acquire(RespConstants.NULL.length).writeBytes(RespConstants.NULL);
                }
                return;
            }
            Collection<Collection<byte[]>> parsed = this.readRandomFields((Map<byte[], byte[]>)res, count, withValues);
            if (countDefined) {
                if (withValues) {
                    Resp3Handler.writeArrayPrefix(parsed.size(), alloc);
                    for (Collection<byte[]> bytes : parsed) {
                        Consumers.GET_ARRAY_BICONSUMER.accept(bytes, (ByteBufPool)alloc);
                    }
                } else {
                    Consumers.GET_ARRAY_BICONSUMER.accept(parsed.stream().flatMap(Collection::stream).toList(), (ByteBufPool)alloc);
                }
            } else {
                Collection<byte[]> bytes = parsed.iterator().next();
                Consumers.GET_BICONSUMER.accept(bytes.iterator().next(), (ByteBufPool)alloc);
            }
        };
    }

    private Collection<Collection<byte[]>> readRandomFields(Map<byte[], byte[]> values, int count, boolean withValues) {
        if (count > 0) {
            return values.entrySet().stream().map(entry -> withValues ? List.of((byte[])entry.getKey(), (byte[])entry.getValue()) : List.of((byte[])entry.getKey())).collect(Collectors.toList());
        }
        ArrayList<Map.Entry<byte[], byte[]>> entries = new ArrayList<Map.Entry<byte[], byte[]>>(values.entrySet());
        return ThreadLocalRandom.current().ints(0, entries.size()).limit(Math.abs(count)).mapToObj(i -> {
            Map.Entry entry = (Map.Entry)entries.get(i);
            return withValues ? List.of((byte[])entry.getKey(), (byte[])entry.getValue()) : List.of((byte[])entry.getKey());
        }).collect(Collectors.toList());
    }
}

