/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.nio.file.Path;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.CorsConfiguration;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.EncryptionConfiguration;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;

@BuiltBy(value=RestServerConfigurationBuilder.class)
@ConfigurationFor(value=RestServer.class)
public class RestServerConfiguration
extends ProtocolServerConfiguration<RestServerConfiguration> {
    public static final AttributeDefinition<ExtendedHeaders> EXTENDED_HEADERS = AttributeDefinition.builder((String)"extended-headers", (Object)((Object)ExtendedHeaders.ON_DEMAND)).immutable().build();
    public static final AttributeDefinition<String> CONTEXT_PATH = AttributeDefinition.builder((String)"context-path", (Object)"rest").immutable().build();
    public static final AttributeDefinition<Integer> MAX_CONTENT_LENGTH = AttributeDefinition.builder((String)"max-content-length", (Object)0xA00000).immutable().build();
    public static final AttributeDefinition<Integer> COMPRESSION_LEVEL = AttributeDefinition.builder((String)"compression-level", (Object)6).immutable().build();
    private final Attribute<ExtendedHeaders> extendedHeaders;
    private final Attribute<String> contextPath;
    private final Attribute<Integer> maxContentLength;
    private final Attribute<Integer> compressionLevel;
    private final Path staticResources;
    private final AuthenticationConfiguration authentication;
    private final CorsConfiguration cors;
    private final EncryptionConfiguration encryption;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RestServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{EXTENDED_HEADERS, CONTEXT_PATH, MAX_CONTENT_LENGTH, COMPRESSION_LEVEL});
    }

    RestServerConfiguration(AttributeSet attributes, SslConfiguration ssl, Path staticResources, AuthenticationConfiguration authentication, CorsConfiguration cors, EncryptionConfiguration encryption, IpFilterConfiguration ipRules) {
        super("rest-connector", attributes, ssl, ipRules);
        this.staticResources = staticResources;
        this.authentication = authentication;
        this.extendedHeaders = attributes.attribute(EXTENDED_HEADERS);
        this.contextPath = attributes.attribute(CONTEXT_PATH);
        this.maxContentLength = attributes.attribute(MAX_CONTENT_LENGTH);
        this.cors = cors;
        this.compressionLevel = attributes.attribute(COMPRESSION_LEVEL);
        this.encryption = encryption;
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    public ExtendedHeaders extendedHeaders() {
        return (ExtendedHeaders)((Object)this.extendedHeaders.get());
    }

    public Path staticResources() {
        return this.staticResources;
    }

    public String contextPath() {
        return (String)this.contextPath.get();
    }

    public int maxContentLength() {
        return (Integer)this.maxContentLength.get();
    }

    public List<CorsConfig> getCorsRules() {
        return this.cors.corsConfigs();
    }

    public CorsConfiguration cors() {
        return this.cors;
    }

    public int getCompressionLevel() {
        return (Integer)this.compressionLevel.get();
    }

    public String toString() {
        return "RestServerConfiguration{authentication=" + this.authentication + ", cors=" + this.cors + ", encryption=" + this.encryption + "}";
    }
}

