/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheManagerListenerAction;
import org.infinispan.security.actions.GetCacheAuthorizationManagerAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheDistributionManagerAction;
import org.infinispan.security.actions.GetCacheEntryAsyncAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetClusterExecutorAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.actions.RemoveListenerAsyncAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static void addListener(EmbeddedCacheManager cacheManager, Object listener) {
        SecurityActions.doPrivileged(new AddCacheManagerListenerAction(cacheManager, listener));
    }

    static CompletionStage<Void> removeListenerAsync(Listenable listenable, Object listener) {
        RemoveListenerAsyncAction action = new RemoveListenerAsyncAction(listenable, listener);
        return (CompletionStage)SecurityActions.doPrivileged(action);
    }

    static DistributionManager getDistributionManager(Cache<?, ?> cache) {
        GetCacheDistributionManagerAction action = new GetCacheDistributionManagerAction(cache.getAdvancedCache());
        return (DistributionManager)SecurityActions.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static <K, V> CompletionStage<CacheEntry<K, V>> getCacheEntryAsync(AdvancedCache<K, V> cache, K key) {
        GetCacheEntryAsyncAction action = new GetCacheEntryAsyncAction(cache, key);
        return (CompletionStage)SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    static ClusterExecutor getClusterExecutor(EmbeddedCacheManager cacheManager) {
        return (ClusterExecutor)SecurityActions.doPrivileged(new GetClusterExecutorAction(cacheManager));
    }

    static AuthorizationManager getCacheAuthorizationManager(AdvancedCache<?, ?> cache) {
        return (AuthorizationManager)SecurityActions.doPrivileged(new GetCacheAuthorizationManagerAction(cache));
    }
}

