/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.rest.ServerSentEvent;
import org.infinispan.rest.logging.Log;

public class EventStream
implements Closeable {
    private static final Log log = (Log)LogFactory.getLog(EventStream.class, Log.class);
    private final Consumer<EventStream> onOpen;
    private final Runnable onClose;
    private ChannelHandlerContext ctx;

    public EventStream(Consumer<EventStream> onOpen, Runnable onClose) {
        this.onOpen = onOpen;
        this.onClose = onClose;
    }

    public CompletionStage<Void> sendEvent(ServerSentEvent e) {
        if (this.ctx != null) {
            log.tracef("Sending event: %s", e);
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            this.ctx.writeAndFlush((Object)e).addListener(v -> cf.complete(null));
            return cf;
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public void close() throws IOException {
        log.tracef("Closing listener", new Object[0]);
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void setChannelHandlerContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        ctx.channel().closeFuture().addListener(f -> this.close());
        if (this.onOpen != null) {
            this.onOpen.accept(this);
        }
    }
}

