/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unsupportedConfigurationOption$str() {
        return "ISPN012004: Unsupported configuration option";
    }

    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedConfigurationOption$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void errorWhileResponding(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorWhileResponding$str(), new Object[0]);
    }

    protected String errorWhileResponding$str() {
        return "ISPN012005: An error occurred while responding to the client";
    }

    @Override
    public final void uncaughtExceptionInThePipeline(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.uncaughtExceptionInThePipeline$str(), new Object[0]);
    }

    protected String uncaughtExceptionInThePipeline$str() {
        return "ISPN012006: Uncaught exception in the pipeline";
    }

    protected String unsupportedDataFormat$str() {
        return "ISPN012007: Cannot convert to %s";
    }

    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(String mediaType) {
        UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(this.getLoggingLocale(), this.unsupportedDataFormat$str(), mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheUnavailable$str() {
        return "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    }

    @Override
    public final ServiceUnavailableException cacheUnavailable(String cacheName) {
        ServiceUnavailableException result = new ServiceUnavailableException(String.format(this.getLoggingLocale(), this.cacheUnavailable$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredMediaType$str() {
        return "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    }

    @Override
    public final NullPointerException missingRequiredMediaType(String cacheName) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.missingRequiredMediaType$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheNotFound$str() {
        return "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    }

    @Override
    public final NoCacheFoundException cacheNotFound(String cacheName) {
        NoCacheFoundException result = new NoCacheFoundException(String.format(this.getLoggingLocale(), this.cacheNotFound$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requestNotAllowedToInternalCaches$str() {
        return "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCaches$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String illegalCompressionLevel$str() {
        return "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";
    }

    @Override
    public final CacheConfigurationException illegalCompressionLevel(int compressionLevel) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.illegalCompressionLevel$str(), compressionLevel));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateResourceMethod$str() {
        return "ISPN012015: Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'";
    }

    @Override
    public final RegistrationException duplicateResourceMethod(String invocationName, Method method, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResourceMethod$str(), new Object[]{invocationName, method, existingPath}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnInvalidNumber(String header, String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidNumber$str(), (Object)header, (Object)value);
    }

    protected String warnInvalidNumber$str() {
        return "ISPN012016: Header '%s' will be ignored, expecting a number but got '%s'";
    }

    protected String authenticationWithoutAuthenticator$str() {
        return "ISPN012017: Cannot enable authentication without an authenticator";
    }

    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutAuthenticator$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPath$str() {
        return "ISPN012018: Cannot register invocation with path '%s': '*' is only allowed at the end";
    }

    @Override
    public final RegistrationException invalidPath(String path) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.invalidPath$str(), path));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateResource$str() {
        return "ISPN012019: Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'";
    }

    @Override
    public final RegistrationException duplicateResource(String candidate, Invocation invocation, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResource$str(), candidate, invocation, existingPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void asyncMassIndexerStarted() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.asyncMassIndexerStarted$str(), new Object[0]);
    }

    protected String asyncMassIndexerStarted$str() {
        return "ISPN012020: MassIndexer started";
    }

    @Override
    public final void asyncMassIndexerSuccess() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.asyncMassIndexerSuccess$str(), new Object[0]);
    }

    protected String asyncMassIndexerSuccess$str() {
        return "ISPN012021: MassIndexer completed successfully";
    }

    @Override
    public final void errorExecutingMassIndexer(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorExecutingMassIndexer$str(), new Object[0]);
    }

    protected String errorExecutingMassIndexer$str() {
        return "ISPN012022: Error executing MassIndexer";
    }

    protected String illegalArgument$str() {
        return "ISPN012023: Argument '%s' has illegal value '%s'";
    }

    @Override
    public final IllegalArgumentException illegalArgument(String name, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgument$str(), name, value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String synchronizedEntries$str() {
        return "ISPN012024: Synchronized %d entries";
    }

    @Override
    public final String synchronizedEntries(long hotrod) {
        return String.format(this.getLoggingLocale(), this.synchronizedEntries$str(), hotrod);
    }

    @Override
    public final void invalidOrigin(String origin, String prop) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidOrigin$str(), (Object)origin, (Object)prop);
    }

    protected String invalidOrigin$str() {
        return "ISPN012025: Ignoring invalid origin '%s' when reading '-D%s'";
    }

    @Override
    public final void warnDeprecatedCall(String invocation) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnDeprecatedCall$str(), (Object)invocation);
    }

    protected String warnDeprecatedCall$str() {
        return "ISPN012026: The REST invocation [%s] has been deprecated. Please consult the upgrade guide";
    }

    protected String authorizationNotEnabled$str() {
        return "ISPN012027: Security authorization is not enabled on this server.";
    }

    @Override
    public final IllegalArgumentException authorizationNotEnabled() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.authorizationNotEnabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String principalRoleMapperNotMutable$str() {
        return "ISPN012028: The principal-role mapper is not mutable";
    }

    @Override
    public final String principalRoleMapperNotMutable() {
        return String.format(this.getLoggingLocale(), this.principalRoleMapperNotMutable$str(), new Object[0]);
    }

    protected String rolePermissionMapperNotMutable$str() {
        return "ISPN012029: The role-permission mapper is not mutable";
    }

    @Override
    public final String rolePermissionMapperNotMutable() {
        return String.format(this.getLoggingLocale(), this.rolePermissionMapperNotMutable$str(), new Object[0]);
    }

    protected String heapDumpFailed$str() {
        return "ISPN012030: Heap dump generation failed";
    }

    @Override
    public final RuntimeException heapDumpFailed(IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.heapDumpFailed$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingContent$str() {
        return "ISPN012031: Method requires content";
    }

    @Override
    public final IllegalArgumentException missingContent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingContent$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongMediaType$str() {
        return "ISPN012032: Wrong media type '%s'. Expecting '%s'";
    }

    @Override
    public final IllegalArgumentException wrongMediaType(String mediaType, String expected) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongMediaType$str(), mediaType, expected));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheCompareWrongContent$str() {
        return "ISPN012033: Wrong content: expecting multipart/form-data with two parts";
    }

    @Override
    public final IllegalArgumentException cacheCompareWrongContent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cacheCompareWrongContent$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongMethod$str() {
        return "ISPN012034: Wrong method '%s'";
    }

    @Override
    public final IllegalArgumentException wrongMethod(String method) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongMethod$str(), method));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String immutableAttribute$str() {
        return "ISPN012035: Attribute '%s' is immutable";
    }

    @Override
    public final IllegalArgumentException immutableAttribute(String attributeName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.immutableAttribute$str(), attributeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleRemoteStores$str() {
        return "ISPN012036: More than one remote store detected, rolling upgrades aren't supported";
    }

    @Override
    public final IllegalStateException multipleRemoteStores() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.multipleRemoteStores$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAction$str() {
        return "ISPN012037: Unknown action '%s'";
    }

    @Override
    public final IllegalArgumentException unknownAction(String action) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAction$str(), action));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notADirectory$str() {
        return "ISPN012038: '%s' must be a directory";
    }

    @Override
    public final IllegalArgumentException notADirectory(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notADirectory$str(), dir));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String restoreFailed$str() {
        return "ISPN012039: Restore failed";
    }

    @Override
    public final IllegalStateException restoreFailed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.restoreFailed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingArgument$str() {
        return "ISPN012040: Missing required argument '%s'";
    }

    @Override
    public final IllegalArgumentException missingArgument(String arg) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingArgument$str(), arg));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backupDeleteFailed$str() {
        return "ISPN012041: Backup delete failed";
    }

    @Override
    public final IllegalStateException backupDeleteFailed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.backupDeleteFailed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backupFailed$str() {
        return "ISPN012042: Backup failed";
    }

    @Override
    public final IllegalStateException backupFailed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.backupFailed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContent$str() {
        return "ISPN012043: Invalid request content";
    }

    @Override
    public final IllegalArgumentException invalidContent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidContent$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingArguments$str() {
        return "ISPN012044: Missing at least one argument in '%s'";
    }

    @Override
    public final IllegalArgumentException missingArguments(String ... level) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingArguments$str(), Arrays.toString(level)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheNotIndexed$str() {
        return "ISPN012045: Cache '%s' is not indexed";
    }

    @Override
    public final IllegalArgumentException cacheNotIndexed(String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cacheNotIndexed$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String statisticsNotEnabled$str() {
        return "ISPN012046: Cache '%s' does not have statistics enabled";
    }

    @Override
    public final IllegalArgumentException statisticsNotEnabled(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.statisticsNotEnabled$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String siteOperationFailed$str() {
        return "ISPN012047: Site operation on '%s' failed: '%s'";
    }

    @Override
    public final IllegalStateException siteOperationFailed(String site, String status) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.siteOperationFailed$str(), site, status));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchScript$str() {
        return "ISPN012048: No such script '%s'";
    }

    @Override
    public final NoSuchElementException noSuchScript(String taskName) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noSuchScript$str(), taskName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String roleAlreadyExists$str() {
        return "ISPN012049: Role already exists";
    }

    @Override
    public final String roleAlreadyExists() {
        return String.format(this.getLoggingLocale(), this.roleAlreadyExists$str(), new Object[0]);
    }

    protected String predefinedRolesAreNotMutable$str() {
        return "ISPN012050: Predefined roles are not mutable";
    }

    @Override
    public final String predefinedRolesAreNotMutable() {
        return String.format(this.getLoggingLocale(), this.predefinedRolesAreNotMutable$str(), new Object[0]);
    }
}

