/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.util.concurrent.TimeUnit;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.Config;
import org.infinispan.commons.test.Eventually;
import org.junit.ComparisonFailure;

public class AeshTestShell
implements Shell {
    private StringBuilder bufferBuilder = new StringBuilder();

    public void write(String msg, boolean paging) {
        this.bufferBuilder.append(msg);
    }

    public void writeln(String msg, boolean paging) {
        this.bufferBuilder.append(msg).append(Config.getLineSeparator());
    }

    public void write(int[] out) {
        this.bufferBuilder.append(Parser.fromCodePoints((int[])out));
    }

    public void write(char out) {
        this.bufferBuilder.append(out);
    }

    public String readLine() throws InterruptedException {
        return null;
    }

    public String readLine(Prompt prompt) throws InterruptedException {
        return null;
    }

    public Key read() throws InterruptedException {
        return null;
    }

    public Key read(long timeout, TimeUnit unit) throws InterruptedException {
        return null;
    }

    public Key read(Prompt prompt) throws InterruptedException {
        return null;
    }

    public boolean enableAlternateBuffer() {
        return false;
    }

    public boolean enableMainBuffer() {
        return false;
    }

    public Size size() {
        return null;
    }

    public void clear() {
        this.bufferBuilder.setLength(0);
    }

    public void assertEquals(String expected) {
        Eventually.eventually(() -> new ComparisonFailure("Expected output was not equal to expected string after timeout", expected, this.bufferBuilder.toString()), () -> expected.equals(this.bufferBuilder.toString()), (long)10000L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void assertContains(String expected) {
        Eventually.eventually(() -> new ComparisonFailure("Expected output did not contain expected string after timeout", expected, this.bufferBuilder.toString()), () -> this.bufferBuilder.toString().contains(expected), (long)10000L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

