/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.persistence;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.Containers;
import org.infinispan.server.test.core.persistence.Database;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class ContainerDatabase
extends Database {
    private static final Log log = LogFactory.getLog(ContainerDatabase.class);
    public static final String DB_PREFIX = "database.container.";
    private static final String ENV_PREFIX = "database.container.env.";
    private final int port;
    private final String volumeName;
    private final boolean volumeRequired;
    private volatile JdbcContainerAdapter<?> container;

    public ContainerDatabase(String type, Properties properties) {
        super(type, properties);
        this.port = Integer.parseInt(this.dbProp(properties, "port"));
        this.volumeName = Util.threadLocalRandomUUID().toString();
        this.volumeRequired = Boolean.parseBoolean(this.dbProp(properties, "volume"));
        this.container = this.createContainer(true);
    }

    private JdbcContainerAdapter<?> createContainer(boolean createVolume) {
        String logMessageWaitStrategy;
        Map<String, String> env = this.properties.entrySet().stream().filter(e -> e.getKey().toString().startsWith(ENV_PREFIX)).collect(Collectors.toMap(e -> e.getKey().toString().substring(ENV_PREFIX.length()), e -> e.getValue().toString()));
        ImageFromDockerfile image = (ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(this.dbProp(this.properties, "name") + ":" + this.dbProp(this.properties, "tag"))).expose(new Integer[]{this.port})).env(env)).build());
        this.container = (JdbcContainerAdapter)((JdbcContainerAdapter)((JdbcContainerAdapter)new JdbcContainerAdapter(image, this).withExposedPorts(new Integer[]{this.port})).withPrivilegedMode(true)).waitingFor((WaitStrategy)Wait.forListeningPort());
        String initSql = this.initSqlFile();
        if (createVolume && initSql != null) {
            this.container.withInitScript(initSql);
        }
        if ((logMessageWaitStrategy = this.properties.getProperty("org.infinispan.test.database.container.log.regex")) != null) {
            this.container.waitingFor(new LogMessageWaitStrategy().withRegEx(logMessageWaitStrategy).withStartupTimeout(Duration.of(10L, ChronoUnit.MINUTES)));
        }
        if (this.volumeRequired) {
            if (createVolume) {
                log.infof("Creating volume '%s'", (Object)this.volumeName);
                Containers.DOCKER_CLIENT.createVolumeCmd().withName(this.volumeName).exec();
                log.infof("Created volume '%s'", (Object)this.volumeName);
            }
            String volumeMount = this.dbProp(this.properties, "volumeMount");
            this.container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMounts(List.of(new Mount().withSource(this.volumeName).withTarget(volumeMount).withType(MountType.VOLUME))));
        }
        return this.container;
    }

    private String dbProp(Properties props, String prop) {
        return props.getProperty(DB_PREFIX + prop);
    }

    @Override
    public void start() {
        log.infof("Starting database %s", (Object)this.getType());
        this.container.start();
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    public void stop(boolean deleteVolume) {
        log.infof("Stopping database %s", (Object)this.getType());
        this.container.stop();
        log.infof("Stopped database %s", (Object)this.getType());
        if (this.volumeRequired && deleteVolume) {
            log.infof("Removing volume '%s'", (Object)this.volumeName);
            try {
                this.dockerClient().removeVolumeCmd(this.volumeName).exec();
            }
            catch (NotFoundException e) {
                log.infof("Volume '%s' not found", (Object)this.volumeName);
            }
            log.infof("Removed volume '%s'", (Object)this.volumeName);
        }
    }

    public void restart() {
        if (this.container.isRunning()) {
            this.stop(false);
        }
        this.container = this.createContainer(false);
        this.container.start();
    }

    public int getPort() {
        return this.container.getMappedPort(this.port);
    }

    @Override
    public String jdbcUrl() {
        String address = Containers.ipAddress(this.container);
        Properties props = new Properties();
        props.setProperty("container.address", address);
        return StringPropertyReplacer.replaceProperties((String)super.jdbcUrl(), (Properties)props);
    }

    @Override
    public String username() {
        Properties props = new Properties();
        return StringPropertyReplacer.replaceProperties((String)super.username(), (Properties)props);
    }

    @Override
    public String password() {
        Properties props = new Properties();
        return StringPropertyReplacer.replaceProperties((String)super.password(), (Properties)props);
    }

    private DockerClient dockerClient() {
        return DockerClientFactory.instance().client();
    }

    static class JdbcContainerAdapter<SELF extends JdbcContainerAdapter<SELF>>
    extends JdbcDatabaseContainer<SELF> {
        final Database database;

        JdbcContainerAdapter(ImageFromDockerfile image, Database database) {
            super((Future)image);
            this.database = database;
        }

        public String getDriverClassName() {
            return this.database.driverClassName();
        }

        public String getJdbcUrl() {
            return this.database.jdbcUrl();
        }

        public String getUsername() {
            return this.database.username();
        }

        public String getPassword() {
            return this.database.password();
        }

        protected String getTestQueryString() {
            return this.database.testQuery();
        }
    }
}

