/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.persistence;

import java.util.Properties;
import org.infinispan.server.test.core.persistence.ContainerDatabase;
import org.infinispan.server.test.core.persistence.ExternalDatabase;

public abstract class Database {
    public static final String ENV_PREFIX = "database.container.env.";
    private final String type;
    protected Properties properties;

    protected Database(String type, Properties properties) {
        this.type = type;
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public String getDataColumnType() {
        return this.properties.getProperty("data.column.type");
    }

    public String getTimeStampColumnType() {
        return this.properties.getProperty("timestamp.column.type");
    }

    public String getSegmentColumnType() {
        return this.properties.getProperty("segment.column.type");
    }

    public String getIdColumType() {
        return this.properties.getProperty("id.column.type");
    }

    public String jdbcUrl() {
        return this.properties.getProperty("database.jdbc.url");
    }

    public String username() {
        return this.properties.getProperty("database.jdbc.username");
    }

    public String password() {
        return this.properties.getProperty("database.jdbc.password");
    }

    public String driverClassName() {
        return this.properties.getProperty("database.jdbc.driver");
    }

    public String testQuery() {
        return this.properties.getProperty("database.test.query");
    }

    public String initSqlFile() {
        return this.properties.getProperty("database.test.sql-file");
    }

    public static Database fromProperties(String type, Properties properties) {
        String mode;
        switch (mode = properties.getProperty("database.mode")) {
            case "CONTAINER": {
                return new ContainerDatabase(type, properties);
            }
            case "EXTERNAL": {
                return new ExternalDatabase(type, properties);
            }
        }
        throw new IllegalArgumentException(mode);
    }

    public abstract void start();

    public abstract void stop();

    public String toString() {
        return "Database{type='" + this.type + "'}";
    }
}

