/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientXSiteDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit5.AbstractServerExtension;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InfinispanXSiteServerExtension
extends AbstractServerExtension
implements TestClientXSiteDriver,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private final List<TestServer> testServers;
    private final Map<String, TestClient> testClients = new HashMap<String, TestClient>();

    public InfinispanXSiteServerExtension(List<TestServer> testServers) {
        this.testServers = testServers;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.initSuiteClasses(extensionContext);
        this.testServers.forEach(it -> this.startTestServer(extensionContext, (TestServer)it));
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.testServers.forEach(it -> {
            TestClient testClient = new TestClient(it);
            this.startTestClient(extensionContext, testClient);
            this.testClients.put(it.getSiteName(), testClient);
        });
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.testClients.values().forEach(TestClient::clearResources);
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (this.suiteTestClasses.isEmpty()) {
            this.testServers.stream().filter(TestServer::isDriverInitialized).forEach(server -> this.stopTestServer(extensionContext, (TestServer)server));
        }
    }

    public HotRodTestClientDriver hotrod(String siteName) {
        return this.testClients.get(siteName).hotrod();
    }

    public RestTestClientDriver rest(String siteName) {
        return this.testClients.get(siteName).rest();
    }

    public String getMethodName() {
        return this.testClients.values().iterator().next().getMethodName();
    }

    public CounterManager getCounterManager(String siteName) {
        return this.testClients.get(siteName).getCounterManager();
    }

    public <K, V> MultimapCacheManager<K, V> getMultimapCacheManager(String siteName) {
        return this.testClients.get(siteName).getRemoteMultimapCacheManager();
    }

    public List<TestServer> getTestServers() {
        return this.testServers;
    }
}

