/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.spring.common.session.MapSessionProtoAdapter;
import org.infinispan.spring.common.session.SessionUpdateRemappingFunction;

@ProtoAdapter(value=SessionUpdateRemappingFunction.class)
@ProtoTypeId(value=5903)
public class SessionUpdateRemappingFunctionProtoAdapter {
    @ProtoFactory
    static SessionUpdateRemappingFunction createFunction(Collection<MapSessionProtoAdapter.SessionAttribute> attributes, Instant lastAccessedTime, Long maxInactiveSeconds) {
        SessionUpdateRemappingFunction function = new SessionUpdateRemappingFunction();
        function.setLastAccessedTime(lastAccessedTime);
        if (maxInactiveSeconds != null) {
            function.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveSeconds));
        }
        HashMap<String, Object> delta = new HashMap<String, Object>();
        for (MapSessionProtoAdapter.SessionAttribute attribute : attributes) {
            delta.put(attribute.getName(), attribute.getValue());
        }
        function.setDelta(delta);
        return function;
    }

    @ProtoField(number=1)
    Instant getLastAccessedTime(SessionUpdateRemappingFunction function) {
        return function.getLastAccessedTime();
    }

    @ProtoField(number=2)
    Long getMaxInactiveSeconds(SessionUpdateRemappingFunction function) {
        return function.getMaxInactiveInterval() == null ? null : Long.valueOf(function.getMaxInactiveInterval().getSeconds());
    }

    @ProtoField(number=3)
    Collection<MapSessionProtoAdapter.SessionAttribute> getAttributes(SessionUpdateRemappingFunction function) {
        if (function.getDelta() == null) {
            return Collections.emptyList();
        }
        return function.getDelta().entrySet().stream().map(entry -> new MapSessionProtoAdapter.SessionAttribute((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }
}

