/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.PrincipalNameResolver;
import org.infinispan.spring.embedded.session.EmbeddedApplicationPublishedBridge;
import org.infinispan.util.function.SerializablePredicate;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

public class InfinispanEmbeddedSessionRepository
extends AbstractInfinispanSessionRepository {
    public InfinispanEmbeddedSessionRepository(SpringCache cache) {
        super(cache, (AbstractApplicationPublisherBridge)new EmbeddedApplicationPublishedBridge(cache));
    }

    protected void removeFromCacheWithoutNotifications(String originalId) {
        Cache embeddedCache = (Cache)this.nativeCache;
        embeddedCache.getAdvancedCache().withFlags(Flag.SKIP_LISTENER_NOTIFICATION).remove((Object)originalId);
    }

    public Map<String, AbstractInfinispanSessionRepository.InfinispanSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        Cache embeddedCache = (Cache)this.nativeCache;
        Collection sessions = (Collection)embeddedCache.values().stream().filter((SerializablePredicate & Serializable)session -> indexValue.equals(PrincipalNameResolver.getInstance().resolvePrincipal((Session)session))).collect(Collectors::toList);
        return sessions.stream().collect(Collectors.toMap(MapSession::getId, session -> new AbstractInfinispanSessionRepository.InfinispanSession((AbstractInfinispanSessionRepository)this, session, false)));
    }
}

