/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4804)
public class TaskContext {
    private transient EmbeddedCacheManager cacheManager;
    private transient Marshaller marshaller;
    private transient Cache<?, ?> cache;
    private Map<String, Object> parameters = Collections.emptyMap();
    private Subject subject;
    private transient boolean logEvent;

    public TaskContext() {
    }

    public TaskContext(TaskContext other) {
        this.parameters = other.parameters;
        this.subject = other.subject;
    }

    @ProtoFactory
    TaskContext(Collection<TaskParameter> parameters, Subject subject) {
        this.parameters = parameters.stream().collect(Collectors.toMap(p -> p.key, p -> p.value));
        this.subject = subject;
    }

    public TaskContext cacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public TaskContext marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public TaskContext cache(Cache<?, ?> cache) {
        this.cache = cache;
        return this;
    }

    public TaskContext parameters(Map<String, ?> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TaskContext subject(Subject subject) {
        this.subject = subject;
        return this;
    }

    public TaskContext addParameter(String name, Object value) {
        if (this.parameters == Collections.EMPTY_MAP) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
        return this;
    }

    public TaskContext addOptionalParameter(String name, Object value) {
        if (value != null) {
            return this.addParameter(name, value);
        }
        return this;
    }

    public TaskContext logEvent(boolean logEvent) {
        this.logEvent = logEvent;
        return this;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Optional<Marshaller> getMarshaller() {
        return Optional.ofNullable(this.marshaller);
    }

    public Optional<Cache<?, ?>> getCache() {
        return Optional.ofNullable(this.cache);
    }

    public Optional<Map<String, Object>> getParameters() {
        return Optional.of(this.parameters);
    }

    public Optional<Subject> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public boolean isLogEvent() {
        return this.logEvent;
    }

    public String toString() {
        return "TaskContext{marshaller=" + this.marshaller + ", cache=" + this.cache + ", parameters=" + this.parameters + ", subject=" + this.subject + ", logEvent=" + this.logEvent + '}';
    }

    @ProtoField(value=1)
    Collection<TaskParameter> parameters() {
        return this.parameters.entrySet().stream().map(e -> new TaskParameter((String)e.getKey(), e.getValue().toString())).collect(Collectors.toList());
    }

    @ProtoField(value=2)
    public Subject subject() {
        return this.subject;
    }

    @ProtoTypeId(value=4803)
    static class TaskParameter {
        @ProtoField(value=1)
        String key;
        @ProtoField(value=2)
        String value;

        @ProtoFactory
        TaskParameter(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

