/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

public class SingleFileStoreReader
implements StoreIterator {
    private final FileChannel channel;
    private final MarshallableEntryFactory<?, ?> entryFactory;
    private final FileEntryReader reader;

    public SingleFileStoreReader(StoreProperties props) {
        block6: {
            props.required(Element.LOCATION);
            String filename = props.get(Element.CACHE_NAME) + ".dat";
            Path path = Path.of(props.get(Element.LOCATION), new String[0]).resolve(filename);
            String location = path.toString();
            File file = path.toFile();
            if (!file.exists() || file.isDirectory()) {
                throw new CacheException(String.format("Unable to read SingleFileStore at '%s'", location));
            }
            try {
                this.channel = new RandomAccessFile(file, "rw").getChannel();
                byte[] magicBytes = new byte[SingleFileStore.MAGIC_11_0.length];
                if (this.channel.read(java.nio.ByteBuffer.wrap(magicBytes)) <= 0) {
                    throw new CacheException(String.format("File at \"%s\" is corrupted.", location));
                }
                if (Arrays.equals(magicBytes, SingleFileStore.MAGIC_BEFORE_11)) {
                    this.reader = new OldReader();
                    break block6;
                }
                if (Arrays.equals(magicBytes, SingleFileStore.MAGIC_11_0) || Arrays.equals(magicBytes, SingleFileStore.MAGIC_LATEST)) {
                    this.reader = new NewReader();
                    break block6;
                }
                throw new CacheException(String.format("File at \"%s\" is corrupted. Unexpected magic number.", location));
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.entryFactory = SerializationConfigUtil.getEntryFactory(props);
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
    }

    @Override
    public Iterator<MarshallableEntry> iterator() {
        return new SingleFileIterator();
    }

    private static class OldReader
    extends BaseReader {
        OldReader() {
            super(24);
        }

        @Override
        Entry readEntry() {
            int entrySize = this.byteBuffer.getInt();
            int keyLen = this.byteBuffer.getInt();
            int dataLen = this.byteBuffer.getInt();
            int metadataLen = this.byteBuffer.getInt();
            return new Entry(entrySize, keyLen, dataLen, metadataLen, 0);
        }
    }

    private static interface FileEntryReader {
        public Entry read(FileChannel var1, int var2);

        public boolean hasNext(FileChannel var1, int var2);

        public int keyOffset();
    }

    private static class NewReader
    extends BaseReader {
        NewReader() {
            super(28);
        }

        @Override
        Entry readEntry() {
            int entrySize = this.byteBuffer.getInt();
            int keyLen = this.byteBuffer.getInt();
            int dataLen = this.byteBuffer.getInt();
            int metadataLen = this.byteBuffer.getInt();
            int internalMetadataLen = this.byteBuffer.getInt();
            return new Entry(entrySize, keyLen, dataLen, metadataLen, internalMetadataLen);
        }
    }

    class SingleFileIterator
    implements Iterator<MarshallableEntry> {
        int filePos = 4;

        SingleFileIterator() {
        }

        @Override
        public boolean hasNext() {
            return SingleFileStoreReader.this.reader.hasNext(SingleFileStoreReader.this.channel, this.filePos);
        }

        @Override
        public MarshallableEntry next() {
            while (true) {
                Entry entry;
                if ((entry = SingleFileStoreReader.this.reader.read(SingleFileStoreReader.this.channel, this.filePos)) == null) {
                    throw new NoSuchElementException();
                }
                if (entry.size < entry.keyLen + entry.dataLen + entry.metadataLen + entry.internalMetadataLen) {
                    throw new CacheException(String.format("Failed to read entries from file. Error at offset %d", this.filePos));
                }
                if (entry.keyLen > 0) {
                    try {
                        byte[] data = new byte[entry.keyLen + entry.dataLen];
                        if (SingleFileStoreReader.this.channel.read(java.nio.ByteBuffer.wrap(data), this.filePos + SingleFileStoreReader.this.reader.keyOffset()) <= 0) {
                            throw new CacheException(String.format("Failed to read entries from file. Error at offset %d", this.filePos));
                        }
                        this.filePos += entry.size;
                        ByteBufferImpl keyBb = ByteBufferImpl.create((byte[])data, (int)0, (int)entry.keyLen);
                        ByteBufferImpl valueBb = ByteBufferImpl.create((byte[])data, (int)entry.keyLen, (int)entry.dataLen);
                        return SingleFileStoreReader.this.entryFactory.create((ByteBuffer)keyBb, (ByteBuffer)valueBb);
                    }
                    catch (IOException e) {
                        throw new CacheException(String.format("Unable to read file entry at offset %d", this.filePos), (Throwable)e);
                    }
                }
                this.filePos += entry.size;
            }
        }
    }

    private static abstract class BaseReader
    implements FileEntryReader {
        private final int keyOffset;
        final java.nio.ByteBuffer byteBuffer;

        BaseReader(int keyOffset) {
            this.keyOffset = keyOffset;
            this.byteBuffer = java.nio.ByteBuffer.allocate(keyOffset);
        }

        @Override
        public final Entry read(FileChannel channel, int filePosition) {
            this.byteBuffer.clear().limit(this.keyOffset);
            try {
                if (channel.read(this.byteBuffer, filePosition) <= 0) {
                    return null;
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            this.byteBuffer.flip();
            Entry entry = this.readEntry();
            return entry;
        }

        @Override
        public final boolean hasNext(FileChannel channel, int filePosition) {
            this.byteBuffer.clear().limit(this.keyOffset);
            try {
                return channel.read(this.byteBuffer, filePosition) > 0;
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }

        @Override
        public final int keyOffset() {
            return this.keyOffset;
        }

        abstract Entry readEntry();
    }

    private static class Entry {
        final int size;
        final int keyLen;
        final int dataLen;
        final int metadataLen;
        final int internalMetadataLen;

        private Entry(int size, int keyLen, int dataLen, int metadataLen, int internalMetadataLen) {
            this.size = size;
            this.keyLen = keyLen;
            this.dataLen = dataLen;
            this.metadataLen = metadataLen;
            this.internalMetadataLen = internalMetadataLen;
        }
    }
}

