/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generators;

import java.util.Collection;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.BooleanAsGeneratorSpec;
import org.instancio.generator.specs.CharacterAsGeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.EmitGeneratorSpec;
import org.instancio.generator.specs.EnumAsGeneratorSpec;
import org.instancio.generator.specs.EnumSetGeneratorSpec;
import org.instancio.generator.specs.HashAsGeneratorSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.generator.specs.NumberAsGeneratorSpec;
import org.instancio.generator.specs.OneOfArrayGeneratorSpec;
import org.instancio.generator.specs.OneOfCollectionGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.generators.AtomicGenerators;
import org.instancio.generators.FinanceGenerators;
import org.instancio.generators.IdGenerators;
import org.instancio.generators.IoGenerators;
import org.instancio.generators.MathGenerators;
import org.instancio.generators.NetGenerators;
import org.instancio.generators.NioGenerators;
import org.instancio.generators.TemporalGenerators;
import org.instancio.generators.TextGenerators;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.array.OneOfArrayGenerator;
import org.instancio.internal.generator.domain.hash.HashGenerator;
import org.instancio.internal.generator.lang.BooleanGenerator;
import org.instancio.internal.generator.lang.ByteGenerator;
import org.instancio.internal.generator.lang.CharacterGenerator;
import org.instancio.internal.generator.lang.DoubleGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.generator.lang.FloatGenerator;
import org.instancio.internal.generator.lang.IntegerGenerator;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.ShortGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.generator.util.CollectionGeneratorSpecImpl;
import org.instancio.internal.generator.util.EnumSetGenerator;
import org.instancio.internal.generator.util.MapGeneratorSpecImpl;
import org.instancio.internal.generator.util.OneOfCollectionGenerator;

public class Generators {
    private final GeneratorContext context;

    public Generators(GeneratorContext context) {
        this.context = context;
    }

    public StringGeneratorSpec string() {
        return new StringGenerator(this.context);
    }

    public BooleanAsGeneratorSpec booleans() {
        return new BooleanGenerator(this.context);
    }

    public CharacterAsGeneratorSpec chars() {
        return new CharacterGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Byte> bytes() {
        return new ByteGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Short> shorts() {
        return new ShortGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Integer> ints() {
        return new IntegerGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Long> longs() {
        return new LongGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Float> floats() {
        return new FloatGenerator(this.context);
    }

    public NumberAsGeneratorSpec<Double> doubles() {
        return new DoubleGenerator(this.context);
    }

    public <E extends Enum<E>> EnumAsGeneratorSpec<E> enumOf(Class<E> enumClass) {
        return new EnumGenerator<E>(this.context, enumClass);
    }

    public MathGenerators math() {
        return new MathGenerators(this.context);
    }

    public NetGenerators net() {
        return new NetGenerators(this.context);
    }

    @SafeVarargs
    public final <T> OneOfArrayGeneratorSpec<T> oneOf(T ... choices) {
        return new OneOfArrayGenerator(this.context).oneOf((Object[])choices);
    }

    public final <T> OneOfCollectionGeneratorSpec<T> oneOf(Collection<T> choices) {
        return new OneOfCollectionGenerator(this.context).oneOf((Collection)choices);
    }

    public <T> ArrayGeneratorSpec<T> array() {
        return new ArrayGenerator(this.context);
    }

    public <T> CollectionGeneratorSpec<T> collection() {
        return new CollectionGeneratorSpecImpl(this.context);
    }

    public <E extends Enum<E>> EnumSetGeneratorSpec<E> enumSet(Class<E> enumClass) {
        return new EnumSetGenerator<E>(this.context, enumClass);
    }

    public <K, V> MapGeneratorSpec<K, V> map() {
        return new MapGeneratorSpecImpl(this.context);
    }

    @ExperimentalApi
    public <T> EmitGeneratorSpec<T> emit() {
        return new EmitGenerator(this.context);
    }

    public AtomicGenerators atomic() {
        return new AtomicGenerators(this.context);
    }

    public IoGenerators io() {
        return new IoGenerators(this.context);
    }

    public NioGenerators nio() {
        return new NioGenerators(this.context);
    }

    public TemporalGenerators temporal() {
        return new TemporalGenerators(this.context);
    }

    public TextGenerators text() {
        return new TextGenerators(this.context);
    }

    public IdGenerators id() {
        return new IdGenerators(this.context);
    }

    public HashAsGeneratorSpec hash() {
        return new HashGenerator(this.context);
    }

    public FinanceGenerators finance() {
        return new FinanceGenerators(this.context);
    }
}

