/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.exception.InstancioException;
import org.instancio.generator.AfterGenerate;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.ReflectionUtils;

class FieldNodePopulationFilter
implements NodePopulationFilter {
    private final ModelContext<?> context;

    FieldNodePopulationFilter(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public boolean shouldSkip(InternalNode fieldNode, AfterGenerate afterGenerate, Object objectContainingField) {
        if (fieldNode.is(NodeKind.IGNORED)) {
            return true;
        }
        if (afterGenerate == AfterGenerate.DO_NOT_MODIFY) {
            return true;
        }
        if (this.context.getGenerator(fieldNode).isPresent()) {
            return false;
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS) {
            return ReflectionUtils.hasNonNullValue(fieldNode.getField(), objectContainingField);
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            if (fieldNode.getField() == null) {
                ExceptionHandler.conditionalFailOnError(() -> {
                    throw new InstancioException("Node has a null field: " + fieldNode);
                });
            }
            return ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(fieldNode.getField(), objectContainingField);
        }
        return afterGenerate != AfterGenerate.POPULATE_ALL;
    }
}

