/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.hibernate.validator.constraints.EAN;
import org.hibernate.validator.constraints.ISBN;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraints.UUID;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.beanvalidation.AbstractBeanValidationProvider;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.HibernateBeanValidationHandlerResolver;
import org.instancio.internal.generator.domain.finance.CreditCardNumberGenerator;
import org.instancio.internal.generator.domain.id.EanGenerator;
import org.instancio.internal.generator.domain.id.IsbnGenerator;
import org.instancio.internal.generator.net.URLGenerator;
import org.instancio.internal.generator.text.LuhnGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.NotNull;

final class HibernateBeanValidationProcessor
extends AbstractBeanValidationProvider {
    private final HibernateBeanValidationHandlerResolver resolver = HibernateBeanValidationHandlerResolver.getInstance();

    HibernateBeanValidationProcessor() {
        super(HibernateBeanValidationProcessor.buildMap());
    }

    private static Map<Class<? extends Annotation>, BiFunction<Annotation, GeneratorContext, Generator<?>>> buildMap() {
        HashMap map = new HashMap();
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(EAN.class, (annotation, context) -> HibernateBeanValidationProcessor.getEanGenerator((EAN)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(LuhnCheck.class, (annotation, context) -> HibernateBeanValidationProcessor.getLuhnGenerator((LuhnCheck)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(CreditCardNumber.class, (annotation, context) -> new CreditCardNumberGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(ISBN.class, (annotation, context) -> new IsbnGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(UUID.class, (annotation, context) -> new UUIDGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(URL.class, (annotation, context) -> HibernateBeanValidationProcessor.getUrlGenerator((URL)annotation, context)));
        return map;
    }

    private static URLGenerator getUrlGenerator(URL url, GeneratorContext context) {
        URLGenerator urlGenerator = new URLGenerator(context).port(url.port());
        if (!StringUtils.isBlank(url.protocol())) {
            urlGenerator.protocol(url.protocol());
        }
        if (!StringUtils.isBlank(url.host())) {
            urlGenerator.host(random -> url.host());
        }
        return urlGenerator;
    }

    private static LuhnGenerator getLuhnGenerator(LuhnCheck luhn, GeneratorContext context) {
        LuhnGenerator generator = new LuhnGenerator(context).startIndex(luhn.startIndex()).endIndex(luhn.endIndex());
        if (luhn.checkDigitIndex() != -1) {
            generator.checkIndex(luhn.checkDigitIndex());
        }
        return generator;
    }

    @NotNull
    private static EanGenerator getEanGenerator(EAN ean, GeneratorContext context) {
        EanGenerator generator = new EanGenerator(context);
        if (ean.type() == EAN.Type.EAN8) {
            generator.type8();
        }
        return generator;
    }

    @Override
    protected AnnotationHandlerResolver getAnnotationHandlerResolver() {
        return this.resolver;
    }
}

