/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeneratorResult {
    private static final Hints EMPTY_HINTS = Hints.afterGenerate(AfterGenerate.DO_NOT_MODIFY);
    private static final GeneratorResult NULL_RESULT = new GeneratorResult(null, EMPTY_HINTS);
    private static final GeneratorResult EMPTY_RESULT = new GeneratorResult(null, EMPTY_HINTS);
    private static final GeneratorResult IGNORED_RESULT = new GeneratorResult(null, EMPTY_HINTS);
    private final Object value;
    private final Hints hints;

    private GeneratorResult(@Nullable Object value, @NotNull Hints hints) {
        this.value = value;
        this.hints = hints;
    }

    public static GeneratorResult create(@Nullable Object value, Hints hints) {
        return new GeneratorResult(value, hints);
    }

    public Object getValue() {
        return this.value;
    }

    public Hints getHints() {
        return this.hints;
    }

    public static GeneratorResult nullResult() {
        return NULL_RESULT;
    }

    public static GeneratorResult emptyResult() {
        return EMPTY_RESULT;
    }

    public static GeneratorResult ignoredResult() {
        return IGNORED_RESULT;
    }

    public boolean hasEmitNullHint() {
        InternalGeneratorHint hint = this.hints.get(InternalGeneratorHint.class);
        return hint != null && hint.emitNull();
    }

    public boolean containsNull() {
        return this.value == null;
    }

    public boolean isEmpty() {
        return this == EMPTY_RESULT;
    }

    public boolean isIgnored() {
        return this == IGNORED_RESULT;
    }

    public String toString() {
        return String.format("GeneratorResult[value=%s, hints=%s]", this.value, this.hints);
    }
}

