/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BooleanAsGeneratorSpec;
import org.instancio.generator.specs.BooleanSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.settings.Keys;
import org.instancio.support.Global;

public class BooleanGenerator
extends AbstractGenerator<Boolean>
implements BooleanSpec,
BooleanAsGeneratorSpec {
    private double probability = 0.5;

    public BooleanGenerator() {
        this(Global.generatorContext());
    }

    public BooleanGenerator(GeneratorContext context) {
        super(context);
        super.nullable(context.getSettings().get(Keys.BOOLEAN_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "booleans()";
    }

    @Override
    public BooleanGenerator probability(double probability) {
        ApiValidator.isTrue(probability >= 0.0 && probability <= 1.0, "Probability must be between 0 and 1, inclusive: %s", probability);
        this.probability = probability;
        return this;
    }

    @Override
    public BooleanGenerator nullable() {
        super.nullable(true);
        return this;
    }

    @Override
    protected Boolean tryGenerateNonNull(Random random) {
        return random.diceRoll(this.isNullable()) ? null : Boolean.valueOf(random.trueOrFalse(this.probability));
    }
}

