/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.misc;

import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.Hints;

public final class GeneratorDecorator
implements Generator<Object> {
    private final Generator<?> delegate;
    private final Hints hints;

    public GeneratorDecorator(Generator<?> delegate, Hints hints) {
        this.delegate = delegate;
        this.hints = hints;
    }

    public static Generator<?> decorate(Generator<?> generator, AfterGenerate afterGenerate) {
        Hints originalHints = generator.hints();
        if (originalHints != null && originalHints.afterGenerate() != null) {
            return generator;
        }
        Hints newHints = originalHints == null ? Hints.afterGenerate(afterGenerate) : Hints.builder(originalHints).afterGenerate(afterGenerate).build();
        return new GeneratorDecorator(generator, newHints);
    }

    public Generator<?> getDelegate() {
        return this.delegate;
    }

    @Override
    public Object generate(Random random) {
        return this.delegate.generate(random);
    }

    @Override
    public Hints hints() {
        return this.hints;
    }
}

