/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.util.List;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.instantiation.LeastArgumentsConstructorInstantiationStrategy;
import org.instancio.internal.instantiation.NoArgumentConstructorInstantiationStrategy;
import org.instancio.internal.instantiation.ReflectionFactoryInstantiationStrategy;
import org.instancio.internal.instantiation.ServiceProviderInstantiationStrategy;
import org.instancio.internal.instantiation.UnsafeInstantiationStrategy;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.spi.InstancioServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instantiator {
    private static final Logger LOG = LoggerFactory.getLogger(Instantiator.class);
    private final InstantiationStrategy[] strategies;

    public Instantiator(List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> providerEntries) {
        this.strategies = new InstantiationStrategy[]{new ServiceProviderInstantiationStrategy(providerEntries), new NoArgumentConstructorInstantiationStrategy(), new LeastArgumentsConstructorInstantiationStrategy(), UnsafeInstantiationStrategy.getInstance(), ReflectionFactoryInstantiationStrategy.getInstance()};
    }

    public <T> T instantiate(Class<T> klass) {
        for (InstantiationStrategy strategy : this.strategies) {
            T instance = this.createInstance(klass, strategy);
            if (instance == null) continue;
            return instance;
        }
        LOG.debug("Could not instantiate class '{}'", (Object)klass.getName());
        return null;
    }

    private <T> T createInstance(Class<T> klass, InstantiationStrategy strategy) {
        try {
            LOG.trace("{}: attempting to instantiate {}", (Object)strategy.getClass().getSimpleName(), klass);
            return strategy.createInstance(klass);
        }
        catch (InstancioApiException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            ExceptionHandler.logException("{}: failed instantiating {}", ex, strategy.getClass().getSimpleName(), klass);
            return null;
        }
    }
}

