/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.Objects;
import org.instancio.Scope;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class ScopeImpl
implements Scope {
    private final Class<?> targetClass;
    private final String fieldName;

    public ScopeImpl(Class<?> targetClass, @Nullable String fieldName) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isFieldScope() {
        return this.fieldName != null;
    }

    public Field resolveField() {
        Verify.state(this.isFieldScope(), "Invalid call to resolve field on Class scope: %s", this);
        return ReflectionUtils.getField(this.targetClass, this.fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeImpl)) {
            return false;
        }
        ScopeImpl scope = (ScopeImpl)o;
        return Objects.equals(this.targetClass, scope.targetClass) && Objects.equals(this.fieldName, scope.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.targetClass, this.fieldName);
    }

    public String toString() {
        if (this.fieldName == null) {
            return String.format("scope(%s)", this.targetClass.getSimpleName());
        }
        return String.format("scope(%s, \"%s\")", this.getTargetClass().getSimpleName(), this.fieldName);
    }
}

