/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.instancio.GroupableSelector;
import org.instancio.Selector;
import org.instancio.SelectorGroup;
import org.instancio.TargetSelector;
import org.instancio.exception.InstancioException;
import org.instancio.internal.selectors.Flattener;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.SelectorImpl;

public final class SelectorGroupImpl
implements SelectorGroup,
Flattener {
    private final List<GroupableSelector> selectors;

    public SelectorGroupImpl(GroupableSelector ... selectors) {
        this.selectors = Collections.unmodifiableList(Arrays.asList(selectors));
    }

    public List<Selector> getSelectors() {
        return this.selectors.stream().map(Selector.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<TargetSelector> flatten() {
        ArrayList<TargetSelector> results = new ArrayList<TargetSelector>();
        for (GroupableSelector selector : this.selectors) {
            if (selector instanceof SelectorImpl) {
                results.add(selector);
                continue;
            }
            if (selector instanceof PrimitiveAndWrapperSelectorImpl) {
                results.addAll(((PrimitiveAndWrapperSelectorImpl)selector).flatten());
                continue;
            }
            throw new InstancioException("Unhandled selector: " + selector.getClass());
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorGroupImpl)) {
            return false;
        }
        SelectorGroupImpl that = (SelectorGroupImpl)o;
        return Objects.equals(this.getSelectors(), that.getSelectors());
    }

    public int hashCode() {
        return Objects.hash(this.getSelectors());
    }

    public String toString() {
        if (this.selectors.isEmpty()) {
            return "all()";
        }
        return String.format("all(%n%s%n)", this.selectors.stream().map(it -> "\t" + it).collect(Collectors.joining("," + System.lineSeparator())));
    }
}

