/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.support;

import java.util.Collection;
import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.internal.random.RandomDataGenerator;
import org.instancio.internal.util.Verify;
import org.instancio.support.Seeds;

@InternalApi
public class DefaultRandom
implements Random {
    private final long seed;
    private final java.util.Random random;

    public DefaultRandom() {
        this(Seeds.randomSeed());
    }

    public DefaultRandom(long seed) {
        this.seed = seed;
        this.random = new java.util.Random(seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean trueOrFalse() {
        return this.intRange(0, 1) == 1;
    }

    @Override
    public boolean trueOrFalse(double probability) {
        Verify.isTrue(probability >= 0.0 && probability <= 1.0, "Probability must be between 0 and 1, inclusive: %s", probability);
        return this.doubleRange(0.0, 1.0) <= probability;
    }

    @Override
    public boolean diceRoll(boolean precondition) {
        return precondition && this.intRange(0, 5) == 1;
    }

    @Override
    public byte byteRange(byte min, byte max) {
        return (byte)this.longRange(min, max);
    }

    @Override
    public short shortRange(short min, short max) {
        return (short)this.longRange(min, max);
    }

    @Override
    public int intRange(int min, int max) {
        return (int)this.longRange(min, max);
    }

    @Override
    public long longRange(long min, long max) {
        return RandomDataGenerator.nextLong(this.random, min, max);
    }

    @Override
    public float floatRange(float min, float max) {
        return (float)this.doubleRange(min, max);
    }

    @Override
    public double doubleRange(double min, double max) {
        return RandomDataGenerator.nextDouble(this.random, min, max);
    }

    @Override
    public char characterRange(char min, char max) {
        return (char)this.longRange(min, max);
    }

    @Override
    public char character() {
        return this.trueOrFalse() ? this.lowerCaseCharacter() : this.upperCaseCharacter();
    }

    @Override
    public char lowerCaseCharacter() {
        return this.characterRange('a', 'z');
    }

    @Override
    public char upperCaseCharacter() {
        return this.characterRange('A', 'Z');
    }

    @Override
    public char alphanumericCharacter() {
        return this.longRange(0L, 2L) == 1L ? this.digitChar() : this.character();
    }

    private char digitChar() {
        return this.characterRange('0', '9');
    }

    @Override
    public String lowerCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.lowerCaseCharacter();
        }
        return new String(s);
    }

    @Override
    public String upperCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.upperCaseCharacter();
        }
        return new String(s);
    }

    @Override
    public String digits(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.digitChar();
        }
        return new String(s);
    }

    @Override
    public String stringOf(int length, char ... chars) {
        Verify.isTrue(length >= 0, "Length must not be negative", new Object[0]);
        Verify.isTrue(chars != null && chars.length > 0, "Character array must have at least one element", new Object[0]);
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = chars[this.intRange(0, chars.length - 1)];
        }
        return new String(s);
    }

    @Override
    public String alphanumeric(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.alphanumericCharacter();
        }
        return new String(s);
    }

    @Override
    public String mixedCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.character();
        }
        return new String(s);
    }

    @Override
    public <T> T oneOf(T[] array) {
        Verify.notEmpty(array, "Array must have at least one element", new Object[0]);
        return array[this.intRange(0, array.length - 1)];
    }

    @Override
    public <T> T oneOf(Collection<T> collection) {
        Verify.notEmpty(collection, "Collection must have at least one element", new Object[0]);
        return collection.stream().skip(this.intRange(0, collection.size() - 1)).findFirst().orElse(null);
    }
}

