/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.Optional;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.OptionalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalContainerHint;

public class OptionalGenerator<T>
extends AbstractGenerator<Optional<T>>
implements OptionalGeneratorSpec<T> {
    private boolean allowEmpty;

    public OptionalGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "optional()";
    }

    public OptionalGenerator<T> allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    @Override
    public Optional<T> tryGenerateNonNull(Random random) {
        if (random.diceRoll(this.allowEmpty)) {
            return Optional.empty();
        }
        return null;
    }

    @Override
    public Hints hints() {
        return Hints.builder().with(InternalContainerHint.builder().generateEntries(1).createFunction(args -> args[0] == null ? Optional.empty() : Optional.of(args[0])).build()).build();
    }
}

