/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.Verify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RecordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RecordUtils.class);

    public static <T> T instantiate(Class<T> recordClass, Object ... args) {
        Verify.isTrue(recordClass.isRecord(), "Class '%s' is not a record!", recordClass.getName());
        try {
            Constructor<?> ctor = RecordUtils.getCanonicalConstructor(recordClass);
            if (ctor == null) {
                return null;
            }
            ctor.setAccessible(true);
            return (T)ctor.newInstance(args);
        }
        catch (Exception ex) {
            throw new InstancioException("Error creating a record: " + recordClass, ex);
        }
    }

    private static Constructor<?> getCanonicalConstructor(Class<?> recordClass) {
        Class[] componentTypes = (Class[])Arrays.stream(recordClass.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            return recordClass.getDeclaredConstructor(componentTypes);
        }
        catch (NoSuchMethodException ex) {
            LOG.debug("Unable to resolve canonical constructor for record class '{}'", (Object)recordClass.getName());
            return null;
        }
    }

    private RecordUtils() {
    }
}

