/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraints.UUID;
import org.instancio.exception.InstancioException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.beanvalidation.AbstractBeanValidationProvider;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.HibernateBeanValidationHandlerResolver;
import org.instancio.internal.generator.domain.finance.CreditCardNumberGenerator;
import org.instancio.internal.generator.net.URLGenerator;
import org.instancio.internal.generator.text.LuhnGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.util.StringUtils;

final class HibernateBeanValidationProcessor
extends AbstractBeanValidationProvider {
    private final HibernateBeanValidationHandlerResolver resolver = HibernateBeanValidationHandlerResolver.getInstance();

    HibernateBeanValidationProcessor() {
    }

    @Override
    public boolean isPrimary(Class<? extends Annotation> annotationType) {
        return annotationType == LuhnCheck.class || annotationType == CreditCardNumber.class || annotationType == URL.class || annotationType == UUID.class;
    }

    @Override
    protected Generator<?> resolveGenerator(Annotation annotation, GeneratorContext context) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType == LuhnCheck.class) {
            LuhnCheck luhn = (LuhnCheck)annotation;
            LuhnGenerator generator = new LuhnGenerator(context).startIndex(luhn.startIndex()).endIndex(luhn.endIndex());
            if (luhn.checkDigitIndex() != -1) {
                generator.checkIndex(luhn.checkDigitIndex());
            }
            return generator;
        }
        if (annotationType == CreditCardNumber.class) {
            return new CreditCardNumberGenerator(context);
        }
        if (annotationType == UUID.class) {
            return new UUIDGenerator(context);
        }
        if (annotationType == URL.class) {
            URL url = (URL)annotation;
            URLGenerator urlGenerator = new URLGenerator(context).port(url.port());
            if (!StringUtils.isBlank(url.protocol())) {
                urlGenerator.protocol(url.protocol());
            }
            if (!StringUtils.isBlank(url.host())) {
                urlGenerator.host(random -> url.host());
            }
            return urlGenerator;
        }
        throw new InstancioException("Unmapped primary annotation:  " + annotationType.getName());
    }

    @Override
    protected AnnotationHandlerResolver getAnnotationHandlerResolver() {
        return this.resolver;
    }
}

