/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.SubtypeGeneratorSpec;
import org.instancio.internal.generator.GeneratorProviderFacade;
import org.instancio.internal.generator.GeneratorResolverMaps;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.spi.GeneratorProvider;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorResolver.class);
    private static final List<GeneratorProvider> PROVIDERS = ServiceLoaders.loadAll(GeneratorProvider.class);
    private final GeneratorContext context;
    private final GeneratorProviderFacade generatorProviderFacade;

    public GeneratorResolver(GeneratorContext context) {
        this.context = context;
        this.generatorProviderFacade = new GeneratorProviderFacade(context, PROVIDERS);
    }

    private static Generator<?> loadByClassName(GeneratorContext context, String generateTypeClassName, String generatorClassName) {
        Class<?> targetClass = ReflectionUtils.loadClass(generateTypeClassName);
        Class<?> generatorClass = ReflectionUtils.loadClass(generatorClassName);
        if (targetClass == null || generatorClass == null) {
            return null;
        }
        return GeneratorResolver.instantiateGenerator(generatorClass, context);
    }

    public Optional<Generator<?>> get(Class<?> klass) {
        Optional<Generator<?>> spiGenerator = this.generatorProviderFacade.getGenerator(klass);
        if (spiGenerator.isPresent()) {
            return spiGenerator;
        }
        Generator<?> generator = this.getBuiltInGenerator(klass);
        if (generator == null) {
            generator = klass.isArray() ? new ArrayGenerator(this.context, klass) : (klass.isEnum() ? new EnumGenerator(this.context, klass) : this.getGeneratorForLegacyClass(klass));
        }
        return Optional.ofNullable(generator);
    }

    @Nullable
    private Generator<?> getGeneratorForLegacyClass(Class<?> klass) {
        if ("java.sql.Date".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "java.sql.Date", "org.instancio.internal.generator.sql.SqlDateGenerator");
        }
        if ("java.sql.Timestamp".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "java.sql.Timestamp", "org.instancio.internal.generator.sql.TimestampGenerator");
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "javax.xml.datatype.XMLGregorianCalendar", "org.instancio.internal.generator.xml.XMLGregorianCalendarGenerator");
        }
        return null;
    }

    private Generator<?> getBuiltInGenerator(Class<?> targetClass) {
        Class<?> subtype;
        Class<?> genClass = GeneratorResolverMaps.getGenerator(targetClass);
        if (genClass == null) {
            return null;
        }
        Generator<?> generator = GeneratorResolver.instantiateGenerator(genClass, this.context);
        if (generator instanceof SubtypeGeneratorSpec && (subtype = GeneratorResolverMaps.getSubtype(targetClass)) != null) {
            ((SubtypeGeneratorSpec)((Object)generator)).subtype(subtype);
        }
        return generator;
    }

    private static Generator<?> instantiateGenerator(Class<?> generatorClass, GeneratorContext context) {
        try {
            Constructor<?> constructor = generatorClass.getConstructor(GeneratorContext.class);
            return (Generator)constructor.newInstance(context);
        }
        catch (Exception ex) {
            LOG.debug("Error instantiating generator: {}", generatorClass);
            return null;
        }
    }
}

