/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LongSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;
import org.instancio.settings.Keys;

public class LongGenerator
extends AbstractRandomComparableNumberGeneratorSpec<Long>
implements LongSpec {
    public LongGenerator() {
        this(Global.generatorContext());
    }

    public LongGenerator(GeneratorContext context) {
        super(context, (Long)context.getSettings().get(Keys.LONG_MIN), (Long)context.getSettings().get(Keys.LONG_MAX), (Boolean)context.getSettings().get(Keys.LONG_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "longs()";
    }

    @Override
    public LongGenerator min(Long min) {
        super.min(min);
        return this;
    }

    @Override
    public LongGenerator max(Long max) {
        super.max(max);
        return this;
    }

    @Override
    public LongGenerator range(Long min, Long max) {
        super.range(min, max);
        return this;
    }

    @Override
    public LongGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public LongGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    protected Long generateNonNullValue(Random random) {
        return random.longRange((Long)this.getMin(), (Long)this.getMax());
    }
}

