/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoField;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LocalDateSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;

public class LocalDateGenerator
extends JavaTimeTemporalGenerator<LocalDate>
implements LocalDateSpec {
    static final LocalDate DEFAULT_MIN = Constants.DEFAULT_MIN.toLocalDate();
    static final LocalDate DEFAULT_MAX = Constants.DEFAULT_MAX.toLocalDate();

    public LocalDateGenerator() {
        this(Global.generatorContext());
    }

    public LocalDateGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
    }

    @Override
    public String apiMethod() {
        return "localDate()";
    }

    @Override
    public LocalDateGenerator past() {
        super.past();
        return this;
    }

    @Override
    public LocalDateGenerator future() {
        super.future();
        return this;
    }

    @Override
    public LocalDateGenerator range(LocalDate start, LocalDate end) {
        super.range(start, end);
        return this;
    }

    @Override
    public LocalDateGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    LocalDate getLatestPast() {
        return LocalDate.now().minusDays(1L);
    }

    @Override
    LocalDate getEarliestFuture() {
        return LocalDate.now().plusDays(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((LocalDate)this.min).compareTo((ChronoLocalDate)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public LocalDate generateNonNullValue(Random random) {
        return LocalDate.ofEpochDay(random.longRange(((LocalDate)this.min).getLong(ChronoField.EPOCH_DAY), ((LocalDate)this.max).getLong(ChronoField.EPOCH_DAY)));
    }
}

