/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.PredicateSelector;
import org.instancio.TypeSelectorBuilder;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.selectors.SelectorTargetKind;
import org.instancio.internal.util.Format;

public class TypeSelectorBuilderImpl
implements TypeSelectorBuilder,
SelectorBuilder {
    private final List<Predicate<Class<?>>> classPredicates = new ArrayList(3);
    private final StringBuilder description = new StringBuilder("types()");

    @Override
    public TypeSelectorBuilder of(Class<?> type) {
        ApiValidator.notNull(type, () -> Format.selectorErrorMessage("Type must not be null.", "of", this.description.toString(), new Throwable()));
        this.classPredicates.add(type::isAssignableFrom);
        this.description.append(".of(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public <A extends Annotation> TypeSelectorBuilder annotated(Class<? extends A> annotation) {
        ApiValidator.notNull(annotation, () -> Format.selectorErrorMessage("Type's declared annotation must not be null.", "annotated", this.description.toString(), new Throwable()));
        this.classPredicates.add(klass -> klass.getDeclaredAnnotation(annotation) != null);
        this.description.append(".annotated(").append(annotation.getSimpleName()).append(')');
        return this;
    }

    @Override
    public TypeSelectorBuilder excluding(Class<?> type) {
        ApiValidator.notNull(type, () -> Format.selectorErrorMessage("Excluded type must not be null.", "excluding", this.description.toString(), new Throwable()));
        this.classPredicates.add(klass -> klass != type);
        this.description.append(".excluding(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public PredicateSelector build() {
        Predicate<Class<?>> predicate = Objects::nonNull;
        for (Predicate<Class<?>> p : this.classPredicates) {
            predicate = predicate.and(p);
        }
        return new PredicateSelectorImpl(SelectorTargetKind.CLASS, null, predicate, this.description.toString());
    }

    public String toString() {
        return this.description.toString();
    }
}

