/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import org.instancio.documentation.InternalApi;
import org.instancio.internal.settings.InternalSettings;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;

@InternalApi
public interface RangeAdjuster {
    public static final RangeAdjuster MIN_ADJUSTER = new ForMin(50);
    public static final RangeAdjuster MAX_ADJUSTER = new ForMax(50);

    public <T extends Number> void adjustRange(Settings var1, SettingKey var2, T var3);

    public static class ForMin
    implements RangeAdjuster {
        private final int percentage;

        ForMin(int percentage) {
            this.percentage = percentage;
        }

        @Override
        public <T extends Number> void adjustRange(Settings settings, SettingKey minSetting, T newMax) {
            Number curMin = (Number)settings.get(minSetting);
            Number newMin = NumberUtils.calculateNewMin(curMin, newMax, this.percentage);
            ((InternalSettings)settings).set(minSetting, newMin, false);
        }
    }

    public static class ForMax
    implements RangeAdjuster {
        private final int percentage;

        ForMax(int percentage) {
            this.percentage = percentage;
        }

        @Override
        public <T extends Number> void adjustRange(Settings settings, SettingKey maxSetting, T newMin) {
            Number curMax = (Number)settings.get(maxSetting);
            Number newMax = NumberUtils.calculateNewMax(curMax, newMin, this.percentage);
            ((InternalSettings)settings).set(maxSetting, newMax, false);
        }
    }
}

