/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.SystemProperties;
import org.instancio.internal.util.VoidFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);
    private static final String ERROR_MSG = String.format("Suppressed error because system property '%s' is disabled", "instancio.failOnError");

    private ExceptionHandler() {
    }

    public static <T> Optional<T> conditionalFailOnError(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (InstancioApiException ex) {
            throw ex;
        }
        catch (InstancioException ex) {
            if (SystemProperties.isFailOnError()) {
                throw ex;
            }
            ExceptionHandler.logSuppressed(ex);
        }
        catch (Exception ex) {
            if (SystemProperties.isFailOnError()) {
                throw InstancioException.unhandledException(ex);
            }
            ExceptionHandler.logSuppressed(ex);
        }
        return Optional.empty();
    }

    public static void conditionalFailOnError(VoidFunction function) {
        try {
            function.invoke();
        }
        catch (InstancioApiException ex) {
            throw ex;
        }
        catch (InstancioException ex) {
            if (SystemProperties.isFailOnError()) {
                throw ex;
            }
            ExceptionHandler.logSuppressed(ex);
        }
        catch (Throwable ex) {
            if (SystemProperties.isFailOnError()) {
                throw InstancioException.unhandledException(ex);
            }
            ExceptionHandler.logSuppressed(ex);
        }
    }

    private static void logSuppressed(Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(ERROR_MSG, t);
        } else {
            LOG.debug("{}. {}: {}", new Object[]{ERROR_MSG, t.getClass().getName(), t.getMessage()});
        }
    }

    public static void logException(String msg, Exception ex, Object ... args) {
        String formatted = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        if (LOG.isTraceEnabled()) {
            LOG.trace(formatted, (Throwable)ex);
        } else {
            LOG.debug("{} [caused by {}]", (Object)formatted, (Object)ExceptionHandler.getCausedBy(ex));
        }
    }

    private static String getCausedBy(Exception ex) {
        String causedBy = ex.getClass().getSimpleName();
        if (ex.getMessage() != null) {
            causedBy = causedBy + ": " + ex.getMessage();
        }
        return causedBy;
    }
}

