/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public final class ServiceLoaders {
    private ServiceLoaders() {
    }

    public static <T> List<T> loadAll(Class<T> spi) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi, ServiceLoaders.getClassLoader());
        ArrayList<T> providers = new ArrayList<T>();
        for (T service : serviceLoader) {
            providers.add(service);
        }
        return Collections.unmodifiableList(providers);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }
}

