/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.Mode;
import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetFieldError;
import org.instancio.assignment.OnSetMethodError;
import org.instancio.assignment.OnSetMethodNotFound;
import org.instancio.assignment.SetterStyle;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.generator.AfterGenerate;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.settings.InternalKey;
import org.instancio.internal.settings.RangeAdjuster;
import org.instancio.settings.SettingKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Keys {
    private static final RangeAdjuster MIN_ADJUSTER = RangeAdjuster.MIN_ADJUSTER;
    private static final RangeAdjuster MAX_ADJUSTER = RangeAdjuster.MAX_ADJUSTER;
    private static final List<SettingKey> ALL_KEYS = new ArrayList<SettingKey>();
    public static final SettingKey ARRAY_ELEMENTS_NULLABLE = Keys.register("array.elements.nullable", Boolean.class, false);
    public static final SettingKey ARRAY_MAX_LENGTH = Keys.register("array.max.length", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey ARRAY_MIN_LENGTH = Keys.register("array.min.length", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey ARRAY_NULLABLE = Keys.register("array.nullable", Boolean.class, false);
    public static final SettingKey BOOLEAN_NULLABLE = Keys.register("boolean.nullable", Boolean.class, false);
    public static final SettingKey BYTE_MAX = Keys.register("byte.max", Byte.class, (byte)127, MAX_ADJUSTER);
    public static final SettingKey BYTE_MIN = Keys.register("byte.min", Byte.class, (byte)1, MIN_ADJUSTER);
    public static final SettingKey BYTE_NULLABLE = Keys.register("byte.nullable", Boolean.class, false);
    public static final SettingKey CHARACTER_NULLABLE = Keys.register("character.nullable", Boolean.class, false);
    public static final SettingKey COLLECTION_ELEMENTS_NULLABLE = Keys.register("collection.elements.nullable", Boolean.class, false);
    public static final SettingKey COLLECTION_MAX_SIZE = Keys.register("collection.max.size", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey COLLECTION_MIN_SIZE = Keys.register("collection.min.size", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey COLLECTION_NULLABLE = Keys.register("collection.nullable", Boolean.class, false);
    public static final SettingKey DOUBLE_MAX = Keys.register("double.max", Double.class, 10000.0, MAX_ADJUSTER);
    public static final SettingKey DOUBLE_MIN = Keys.register("double.min", Double.class, 1.0, MIN_ADJUSTER);
    public static final SettingKey DOUBLE_NULLABLE = Keys.register("double.nullable", Boolean.class, false);
    public static final SettingKey FLOAT_MAX = Keys.register("float.max", Float.class, Float.valueOf(10000.0f), MAX_ADJUSTER);
    public static final SettingKey FLOAT_MIN = Keys.register("float.min", Float.class, Float.valueOf(1.0f), MIN_ADJUSTER);
    public static final SettingKey FLOAT_NULLABLE = Keys.register("float.nullable", Boolean.class, false);
    public static final SettingKey INTEGER_MAX = Keys.register("integer.max", Integer.class, 10000, MAX_ADJUSTER);
    public static final SettingKey INTEGER_MIN = Keys.register("integer.min", Integer.class, 1, MIN_ADJUSTER);
    public static final SettingKey INTEGER_NULLABLE = Keys.register("integer.nullable", Boolean.class, false);
    public static final SettingKey LONG_MAX = Keys.register("long.max", Long.class, 10000L, MAX_ADJUSTER);
    public static final SettingKey LONG_MIN = Keys.register("long.min", Long.class, 1L, MIN_ADJUSTER);
    public static final SettingKey LONG_NULLABLE = Keys.register("long.nullable", Boolean.class, false);
    public static final SettingKey MAP_KEYS_NULLABLE = Keys.register("map.keys.nullable", Boolean.class, false);
    public static final SettingKey MAP_MAX_SIZE = Keys.register("map.max.size", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey MAP_MIN_SIZE = Keys.register("map.min.size", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey MAP_NULLABLE = Keys.register("map.nullable", Boolean.class, false);
    public static final SettingKey MAP_VALUES_NULLABLE = Keys.register("map.values.nullable", Boolean.class, false);
    public static final SettingKey MODE = Keys.register("mode", Mode.class, (Object)Mode.STRICT);
    public static final SettingKey AFTER_GENERATE_HINT = Keys.register("hint.after.generate", AfterGenerate.class, (Object)AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES);
    public static final SettingKey OVERWRITE_EXISTING_VALUES = Keys.register("overwrite.existing.values", Boolean.class, true);
    @ExperimentalApi
    public static final SettingKey ASSIGNMENT_TYPE = Keys.register("assignment.type", AssignmentType.class, (Object)AssignmentType.FIELD);
    @ExperimentalApi
    public static final SettingKey ON_SET_FIELD_ERROR = Keys.register("on.set.field.error", OnSetFieldError.class, (Object)OnSetFieldError.IGNORE);
    @ExperimentalApi
    public static final SettingKey ON_SET_METHOD_ERROR = Keys.register("on.set.method.error", OnSetMethodError.class, (Object)OnSetMethodError.ASSIGN_FIELD);
    @ExperimentalApi
    public static final SettingKey ON_SET_METHOD_NOT_FOUND = Keys.register("on.set.method.not.found", OnSetMethodNotFound.class, (Object)OnSetMethodNotFound.ASSIGN_FIELD);
    @ExperimentalApi
    public static final SettingKey SETTER_STYLE = Keys.register("setter.style", SetterStyle.class, (Object)SetterStyle.SET);
    @ExperimentalApi
    public static final SettingKey BEAN_VALIDATION_ENABLED = Keys.register("bean.validation.enabled", Boolean.class, false);
    public static final SettingKey MAX_DEPTH = Keys.register("max.depth", Integer.class, 8);
    public static final SettingKey SEED = Keys.registerWithNullDefault("seed", Long.class);
    public static final SettingKey SHORT_MAX = Keys.register("short.max", Short.class, (short)10000, MAX_ADJUSTER);
    public static final SettingKey SHORT_MIN = Keys.register("short.min", Short.class, (short)1, MIN_ADJUSTER);
    public static final SettingKey SHORT_NULLABLE = Keys.register("short.nullable", Boolean.class, false);
    public static final SettingKey STRING_ALLOW_EMPTY = Keys.register("string.allow.empty", Boolean.class, false);
    public static final SettingKey STRING_MAX_LENGTH = Keys.register("string.max.length", Integer.class, 10, MAX_ADJUSTER);
    public static final SettingKey STRING_MIN_LENGTH = Keys.register("string.min.length", Integer.class, 3, MIN_ADJUSTER);
    public static final SettingKey STRING_NULLABLE = Keys.register("string.nullable", Boolean.class, false);
    public static final SettingKey STRING_FIELD_PREFIX_ENABLED = Keys.register("string.field.prefix.enabled", Boolean.class, false);
    private static final Map<String, SettingKey> SETTING_KEY_MAP = Collections.unmodifiableMap(Keys.settingKeyMap());

    public static List<SettingKey> all() {
        return Collections.unmodifiableList(ALL_KEYS);
    }

    public static SettingKey get(@NotNull String key) {
        SettingKey settingKey = SETTING_KEY_MAP.get(key);
        ApiValidator.isTrue(settingKey != null, "Invalid instancio property key: '%s'", key);
        return settingKey;
    }

    private static SettingKey register(@NotNull String propertyKey, @NotNull Class<?> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNullValue) {
        InternalKey settingKey = new InternalKey(propertyKey, type, defaultValue, rangeAdjuster, allowsNullValue);
        ALL_KEYS.add(settingKey);
        return settingKey;
    }

    private static SettingKey register(@NotNull String propertyKey, @NotNull Class<?> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster) {
        return Keys.register(propertyKey, type, defaultValue, rangeAdjuster, false);
    }

    private static SettingKey register(@NotNull String key, @NotNull Class<?> type, @NotNull Object defaultValue) {
        return Keys.register(key, type, defaultValue, null, false);
    }

    private static SettingKey registerWithNullDefault(@NotNull String key, @NotNull Class<?> type) {
        return Keys.register(key, type, null, null, true);
    }

    private static Map<String, SettingKey> settingKeyMap() {
        HashMap<String, SettingKey> map = new HashMap<String, SettingKey>();
        for (SettingKey key : ALL_KEYS) {
            map.put(key.propertyKey(), key);
        }
        return map;
    }

    private Keys() {
    }
}

