/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.SystemProperties;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);
    private static final String SUPPRESSION_REASON = String.format("Suppressed error because system property '%s' is disabled", "instancio.failOnError");

    private ExceptionHandler() {
    }

    public static <T> Optional<T> conditionalFailOnError(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (AssertionError | InstancioTerminatingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (SystemProperties.shouldFailOnError()) {
                throw Fail.withInternalError(ex);
            }
            ExceptionHandler.logSuppressed(ex);
            return Optional.empty();
        }
    }

    private static void logSuppressed(Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(SUPPRESSION_REASON, t);
        } else {
            LOG.debug("{}. {}: {}", new Object[]{SUPPRESSION_REASON, t.getClass().getName(), t.getMessage()});
        }
    }

    public static void logException(String msg, Throwable t, Object ... args) {
        String formatted = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        if (LOG.isTraceEnabled()) {
            LOG.trace(formatted, t);
        } else {
            LOG.debug("{} [{}]", (Object)formatted, (Object)ExceptionHandler.getCausedBy(t));
        }
    }

    public static void runIgnoringTheNoClassDefFoundError(Runnable action) {
        try {
            action.run();
        }
        catch (NoClassDefFoundError error) {
            LOG.trace("Error is ignored: {}", (Object)error.toString());
        }
    }

    @VisibleForTesting
    static String getCausedBy(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            sb.append(Constants.NL).append(" => caused by: ").append(t.getClass().getSimpleName());
            if (t.getMessage() == null) continue;
            sb.append(": \"").append(t.getMessage()).append('\"');
        }
        return sb.toString();
    }
}

