/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.InternalContainerFactoryProvider;

class ContainerFactoriesHandler {
    private final List<InternalContainerFactoryProvider> providers;

    ContainerFactoriesHandler(List<InternalContainerFactoryProvider> providers) {
        this.providers = providers;
    }

    GeneratorResult substituteResult(InternalNode node, GeneratorResult result) {
        List<Class<?>> typeArgs = node.getChildren().stream().map(InternalNode::getTargetClass).collect(Collectors.toList());
        for (InternalContainerFactoryProvider provider : this.providers) {
            Function fn = provider.getMappingFunction(node.getTargetClass(), typeArgs);
            if (fn == null) continue;
            Object replacement = fn.apply(result.getValue());
            return GeneratorResult.create(replacement, result.getHints());
        }
        return result;
    }
}

