/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.exception.InstancioException;
import org.instancio.generator.AfterGenerate;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ReflectionUtils;

final class FieldNodePopulationFilter
implements NodePopulationFilter {
    FieldNodePopulationFilter() {
    }

    @Override
    public boolean shouldSkip(InternalNode node, AfterGenerate afterGenerate, Object owner) {
        if (afterGenerate == AfterGenerate.POPULATE_NULLS) {
            return ReflectionUtils.hasNonNullValue(node.getField(), owner);
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            if (node.getField() == null) {
                throw new InstancioException("Node has a null field: " + node);
            }
            return ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(node.getField(), owner);
        }
        return afterGenerate != AfterGenerate.POPULATE_ALL;
    }
}

