/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assignment;

import java.util.function.Supplier;
import org.instancio.GeneratorSpecProvider;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.misc.GeneratorDecorator;

public final class GeneratorHolder {
    private final Generator<?> generator;
    private final GeneratorSpecProvider<?> specProvider;

    private GeneratorHolder(Generator<?> generator, GeneratorSpecProvider<?> specProvider) {
        this.generator = generator;
        this.specProvider = specProvider;
    }

    static GeneratorHolder of(Generator<?> generator) {
        ApiValidator.validateGeneratorNotNull(generator);
        return new GeneratorHolder(generator, null);
    }

    static GeneratorHolder of(GeneratorSpec<?> spec) {
        ApiValidator.validateGenerateSecondArgument(spec);
        return new GeneratorHolder((Generator)spec, null);
    }

    static <T> GeneratorHolder of(Supplier<T> supplier) {
        ApiValidator.validateSupplierNotNull(supplier);
        Generator<T> generator = GeneratorDecorator.decorate(supplier);
        return GeneratorHolder.of(generator);
    }

    static <T> GeneratorHolder of(GeneratorSpecProvider<T> specProvider) {
        ApiValidator.validateGenerateSecondArgument(specProvider);
        return new GeneratorHolder(null, specProvider);
    }

    static <T> GeneratorHolder of(T obj) {
        Supplier<Object> supplier = () -> obj;
        return GeneratorHolder.of(supplier);
    }

    public <T> Generator<T> getGenerator() {
        return this.generator;
    }

    public <T> GeneratorSpecProvider<T> getSpecProvider() {
        return this.specProvider;
    }
}

