/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class InstantiatingHandler
implements NodeHandler {
    private static final Hints POPULATE_ALL_HINT = Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).build();
    private final Instantiator instantiator;

    public InstantiatingHandler(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        if (node.is(NodeKind.RECORD) && !node.getChildren().isEmpty()) {
            return GeneratorResult.emptyResult();
        }
        Class<?> targetClass = node.getTargetClass();
        if (ReflectionUtils.isArrayOrConcrete(targetClass)) {
            Object object = this.instantiator.instantiate(targetClass);
            return GeneratorResult.create(object, POPULATE_ALL_HINT);
        }
        return GeneratorResult.emptyResult();
    }
}

