/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.annotation.AnnotationConsumer;
import org.instancio.internal.annotation.AnnotationGeneratorFn;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.AnnotationMap;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.util.Verify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnnotationConsumer
implements AnnotationConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnnotationConsumer.class);
    private final Map<Class<? extends Annotation>, AnnotationGeneratorFn> primaryAnnotations = new HashMap<Class<? extends Annotation>, AnnotationGeneratorFn>();

    AbstractAnnotationConsumer() {
    }

    protected abstract AnnotationHandlerMap getAnnotationHandlerMap();

    final <A extends Annotation> void register(Supplier<Class<A>> annotationTypeSupplier, AnnotationGeneratorFn annotationGeneratorFn) {
        try {
            this.primaryAnnotations.put(annotationTypeSupplier.get(), annotationGeneratorFn);
        }
        catch (NoClassDefFoundError error) {
            LOG.trace("Annotation not available on classpath: {}", (Object)error.toString());
        }
    }

    @Override
    public final boolean isPrimary(Class<? extends Annotation> annotationType) {
        return this.primaryAnnotations.containsKey(annotationType);
    }

    @Override
    public final void consumeAnnotations(AnnotationMap annotationMap, GeneratorSpec<?> spec, Class<?> targetClass, Field field) {
        Annotation primaryAnnotation = annotationMap.removePrimary();
        AnnotationHandlerMap annotationHandlerMap = this.getAnnotationHandlerMap();
        if (primaryAnnotation != null) {
            AbstractGenerator suppliedGenerator = (AbstractGenerator)spec;
            GeneratorContext context = suppliedGenerator.getContext();
            Generator<?> actualGenerator = this.resolveGenerator(primaryAnnotation, context);
            if (spec instanceof StringGenerator) {
                ((StringGenerator)spec).setDelegate(actualGenerator);
            } else {
                LOG.warn("Ignoring annotation {} on a non-string field: {}", (Object)primaryAnnotation.annotationType().getName(), (Object)field);
            }
        }
        Collection<Annotation> annotations = annotationMap.getAnnotations();
        for (Annotation annotation : annotations) {
            FieldAnnotationHandler handler = annotationHandlerMap.get(annotation);
            if (handler == null) continue;
            handler.process(annotation, spec, field, targetClass);
            annotationMap.remove(annotation.annotationType());
        }
    }

    private Generator<?> resolveGenerator(Annotation annotation, GeneratorContext context) {
        AnnotationGeneratorFn generatorFn = this.primaryAnnotations.get(annotation.annotationType());
        Verify.notNull(generatorFn, "Unmapped primary annotation: %s", annotation.annotationType());
        return generatorFn.apply(annotation, context);
    }
}

