/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.function.Function;
import org.instancio.Random;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.BigDecimalGeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.AnnotationUtils;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.lang.BooleanGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.util.CollectionGenerator;
import org.instancio.internal.generator.util.MapGenerator;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.Range;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.Keys;

class CommonBeanValidationHandlerMap
extends AnnotationHandlerMap {
    CommonBeanValidationHandlerMap() {
    }

    static final class AssertBooleanHandler
    implements FieldAnnotationHandler {
        private final boolean generatedValue;

        AssertBooleanHandler(boolean generatedValue) {
            this.generatedValue = generatedValue;
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof BooleanGenerator) {
                ((BooleanGenerator)spec).probability(this.generatedValue ? 1.0 : 0.0);
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static final class NotNullHandler
    implements FieldAnnotationHandler {
        NotNullHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            AnnotationUtils.setSpecNullableToFalse(spec);
        }
    }

    static final class NotEmptyHandler
    implements FieldAnnotationHandler {
        NotEmptyHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof StringGenerator) {
                StringGenerator generator = (StringGenerator)spec;
                generator.minLength(Math.max(generator.getMinLength(), 1)).nullable(false).allowEmpty(false);
            } else if (spec instanceof ArrayGenerator) {
                ((ArrayGenerator)spec).nullable(false).minLength(Keys.ARRAY_MIN_LENGTH.defaultValue());
            } else if (spec instanceof CollectionGenerator) {
                ((CollectionGenerator)spec).nullable(false).minSize(Keys.COLLECTION_MIN_SIZE.defaultValue());
            } else if (spec instanceof MapGenerator) {
                ((MapGenerator)spec).nullable(false).minSize(Keys.MAP_MIN_SIZE.defaultValue());
            }
        }
    }

    static abstract class AbstractSizeHandler
    implements FieldAnnotationHandler {
        AbstractSizeHandler() {
        }

        abstract int getMin(Annotation var1);

        abstract int getMax(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof StringGeneratorSpec) {
                Range<Integer> range = AnnotationUtils.calculateRange(this.getMin(annotation), this.getMax(annotation), Keys.STRING_MAX_LENGTH.defaultValue());
                StringGeneratorSpec stringSpec = (StringGeneratorSpec)spec;
                stringSpec.length(range.min(), range.max());
                if (this.getMin(annotation) > 0) {
                    stringSpec.allowEmpty(false);
                }
            } else if (spec instanceof CollectionGeneratorSpec) {
                Range<Integer> range = AnnotationUtils.calculateRange(this.getMin(annotation), this.getMax(annotation), Keys.COLLECTION_MAX_SIZE.defaultValue());
                ((CollectionGeneratorSpec)spec).minSize(range.min()).maxSize(range.max());
            } else if (spec instanceof MapGeneratorSpec) {
                Range<Integer> range = AnnotationUtils.calculateRange(this.getMin(annotation), this.getMax(annotation), Keys.MAP_MAX_SIZE.defaultValue());
                ((MapGeneratorSpec)spec).minSize(range.min()).maxSize(range.max());
            } else if (spec instanceof ArrayGeneratorSpec) {
                Range<Integer> range = AnnotationUtils.calculateRange(this.getMin(annotation), this.getMax(annotation), Keys.ARRAY_MAX_LENGTH.defaultValue());
                ((ArrayGeneratorSpec)spec).minLength(range.min()).maxLength(range.max());
            }
        }
    }

    static final class FutureHandler
    implements FieldAnnotationHandler {
        FutureHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof TemporalGeneratorSpec) {
                ((TemporalGeneratorSpec)spec).future();
            }
        }
    }

    static final class PastHandler
    implements FieldAnnotationHandler {
        PastHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof TemporalGeneratorSpec) {
                ((TemporalGeneratorSpec)spec).past();
            }
        }
    }

    static final class NegativeHandler
    implements FieldAnnotationHandler {
        private final BigDecimal max;

        NegativeHandler(BigDecimal max) {
            this.max = max;
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                Object numberMinValue = NumberUtils.getMinValue(fieldType);
                numSpec.min((Number)converter.apply(new BigDecimal(numberMinValue.toString()))).max((Number)converter.apply(this.max));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static final class PositiveHandler
    implements FieldAnnotationHandler {
        private final BigDecimal min;

        PositiveHandler(BigDecimal min) {
            this.min = min;
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                Object numberMaxValue = NumberUtils.getMaxValue(fieldType);
                numSpec.min((Number)converter.apply(this.min)).max((Number)converter.apply(new BigDecimal(numberMaxValue.toString())));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static abstract class AbstractDecimalMaxHandler
    implements FieldAnnotationHandler {
        AbstractDecimalMaxHandler() {
        }

        abstract String getValue(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                String value = this.getValue(annotation);
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                BigDecimal max = new BigDecimal(value);
                ((NumberGeneratorSpec)spec).max((Number)converter.apply(max));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static abstract class AbstractDecimalMinHandler
    implements FieldAnnotationHandler {
        AbstractDecimalMinHandler() {
        }

        abstract String getValue(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                String value = this.getValue(annotation);
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                BigDecimal min = new BigDecimal(value);
                AbstractRandomNumberGeneratorSpec numSpec = (AbstractRandomNumberGeneratorSpec)spec;
                numSpec.min((Number)converter.apply(min));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static abstract class AbstractMaxHandler
    implements FieldAnnotationHandler {
        AbstractMaxHandler() {
        }

        abstract long getValue(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                ((NumberGeneratorSpec)spec).max((Number)fromLongConverter.apply(this.getValue(annotation)));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static abstract class AbstractMinHandler
    implements FieldAnnotationHandler {
        AbstractMinHandler() {
        }

        abstract long getValue(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                ((NumberGeneratorSpec)spec).min((Number)fromLongConverter.apply(this.getValue(annotation)));
                AnnotationUtils.setSpecNullableToFalse(spec);
            }
        }
    }

    static abstract class AbstractDigitsHandler
    implements FieldAnnotationHandler {
        AbstractDigitsHandler() {
        }

        abstract int getFraction(Annotation var1);

        abstract int getInteger(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            int fraction = this.getFraction(annotation);
            if (spec instanceof StringGenerator) {
                StringGenerator generator = (StringGenerator)spec;
                generator.digits().length(this.getInteger(annotation)).allowEmpty(false);
                if (fraction > 0) {
                    Random random = generator.getContext().random();
                    generator.suffix("." + random.digits(fraction));
                }
            } else if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                int integer = this.getInteger(annotation);
                BigDecimal min = integer == 0 ? BigDecimal.ZERO : BigDecimal.TEN.pow(integer - 1);
                BigDecimal max = BigDecimal.TEN.pow(integer).subtract(BigDecimal.ONE);
                if (NumberUtils.isZero(min) && NumberUtils.isZero(max) && fraction > 0) {
                    max = new BigDecimal("0." + StringUtils.repeat("9", fraction));
                }
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                numSpec.min((Number)converter.apply(min));
                numSpec.max((Number)converter.apply(max));
                AnnotationUtils.setSpecNullableToFalse(spec);
                if (spec instanceof BigDecimalGeneratorSpec) {
                    ((BigDecimalGeneratorSpec)spec).scale(fraction);
                }
            }
        }
    }
}

