/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.instancio.PredicateSelector;
import org.instancio.Scope;
import org.instancio.TargetSelector;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SortedSetWithReverseInsertionOrder;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.ScopelessSelector;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ReflectionUtils;

final class SelectorMapImpl<V>
implements SelectorMap<V> {
    private static final boolean FIND_ONE_ONLY = true;
    private static final SelectorMap<?> EMPTY_MAP = new EmptyMap();
    private static final ScopelessSelector SCOPELESS_ROOT = new ScopelessSelector(null);
    private final Map<ScopelessSelector, List<SelectorImpl>> scopelessSelectors = new LinkedHashMap<ScopelessSelector, List<SelectorImpl>>(0);
    private final Map<TargetSelector, V> selectors = new LinkedHashMap<TargetSelector, V>(0);
    private final Set<TargetSelector> unusedSelectors = new LinkedHashSet<TargetSelector>(0);
    private final Set<PredicateSelectorEntry<V>> predicateSelectors = new SortedSetWithReverseInsertionOrder<PredicateSelectorEntry>(Comparator.comparingInt(o -> ((PredicateSelectorEntry)o).predicateSelector.getPriority()));

    SelectorMapImpl() {
    }

    public static <T> SelectorMap<T> emptyMap() {
        return EMPTY_MAP;
    }

    @Override
    public void forEach(BiConsumer<TargetSelector, V> action) {
        for (Map.Entry<TargetSelector, V> entry : this.selectors.entrySet()) {
            TargetSelector selector = entry.getKey();
            V value = entry.getValue();
            action.accept(selector, value);
        }
        for (PredicateSelectorEntry predicateSelectorEntry : this.predicateSelectors) {
            action.accept(predicateSelectorEntry.predicateSelector, predicateSelectorEntry.value);
        }
    }

    @Override
    public void put(TargetSelector targetSelector, V value) {
        if (targetSelector instanceof SelectorImpl) {
            ScopelessSelector scopeless;
            SelectorImpl selector = (SelectorImpl)targetSelector;
            if (selector.isRoot()) {
                scopeless = SCOPELESS_ROOT;
            } else if (selector.isFieldSelector()) {
                Field field = ReflectionUtils.getField(selector.getTargetClass(), selector.getFieldName());
                scopeless = new ScopelessSelector(field.getDeclaringClass(), field);
            } else {
                scopeless = new ScopelessSelector(selector.getTargetClass());
            }
            this.selectors.put(selector, value);
            this.unusedSelectors.add(selector);
            this.scopelessSelectors.computeIfAbsent(scopeless, selectorList -> new ArrayList(3)).add(selector);
        } else if (targetSelector instanceof PredicateSelector) {
            PredicateSelectorImpl selector = (PredicateSelectorImpl)targetSelector;
            this.predicateSelectors.add(new PredicateSelectorEntry(selector, value));
        } else {
            throw Fail.withFataInternalError("Invalid selector type: " + targetSelector.getClass().getName(), new Object[0]);
        }
    }

    @Override
    public Set<TargetSelector> getUnusedKeys() {
        HashSet<TargetSelector> unused = new HashSet<TargetSelector>(this.unusedSelectors);
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (((PredicateSelectorEntry)entry).matched) continue;
            unused.add(((PredicateSelectorEntry)entry).predicateSelector);
        }
        return unused;
    }

    @Override
    public Optional<V> getValue(InternalNode node) {
        List<SelectorImpl> withParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), true);
        if (!withParent.isEmpty()) {
            SelectorImpl selector = withParent.get(0);
            this.markUsed(selector);
            return Optional.of(this.selectors.get(selector));
        }
        return this.getPredicateSelectorMatch(node);
    }

    private Optional<V> getPredicateSelectorMatch(InternalNode node) {
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, entry)) continue;
            ((PredicateSelectorEntry)entry).matched = true;
            return Optional.of(((PredicateSelectorEntry)entry).value);
        }
        return Optional.empty();
    }

    @Override
    public List<V> getValues(InternalNode node) {
        List<SelectorImpl> selectorsWithParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), false);
        ArrayList<Object> values = new ArrayList<Object>();
        for (SelectorImpl selectorImpl : selectorsWithParent) {
            this.markUsed(selectorImpl);
            values.add(this.selectors.get(selectorImpl));
        }
        for (PredicateSelectorEntry predicateSelectorEntry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, predicateSelectorEntry)) continue;
            predicateSelectorEntry.matched = true;
            values.add(predicateSelectorEntry.value);
        }
        return values;
    }

    @Override
    public Set<TargetSelector> getSelectors(InternalNode node) {
        List<SelectorImpl> selectorsWithParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), false);
        HashSet<TargetSelector> results = new HashSet<TargetSelector>(selectorsWithParent);
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, entry)) continue;
            results.add(((PredicateSelectorEntry)entry).predicateSelector);
        }
        return results;
    }

    private static boolean isPredicateMatch(InternalNode node, PredicateSelectorEntry<?> entry) {
        return ((PredicateSelectorEntry)entry).predicateSelector.getNodePredicate().test(node);
    }

    private void markUsed(SelectorImpl selector) {
        if (selector.getParent() instanceof PrimitiveAndWrapperSelectorImpl) {
            SelectorImpl equivalent = selector.toBuilder().targetClass(PrimitiveWrapperBiLookup.getEquivalent(selector.getTargetClass())).build();
            this.unusedSelectors.remove(equivalent);
        }
        this.unusedSelectors.remove(selector);
    }

    private List<SelectorImpl> getCandidates(InternalNode node) {
        if (node.getParent() == null && this.scopelessSelectors.containsKey(SCOPELESS_ROOT)) {
            return Collections.singletonList(this.scopelessSelectors.get(SCOPELESS_ROOT).get(0));
        }
        ArrayList<SelectorImpl> candidates = new ArrayList<SelectorImpl>(this.scopelessSelectors.getOrDefault(new ScopelessSelector(node.getRawType()), Collections.emptyList()));
        if (node.getField() != null) {
            ScopelessSelector key = new ScopelessSelector(node.getField().getDeclaringClass(), node.getField());
            List fieldSelectors = this.scopelessSelectors.getOrDefault(key, Collections.emptyList());
            candidates.addAll(fieldSelectors);
        }
        return candidates;
    }

    private static List<SelectorImpl> getSelectorsWithParent(InternalNode targetNode, List<SelectorImpl> candidates, boolean findOneOnly) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SelectorImpl> results = new ArrayList<SelectorImpl>(3);
        for (int i = candidates.size() - 1; i >= 0 && (!findOneOnly || results.isEmpty()); --i) {
            SelectorImpl candidate = candidates.get(i);
            if (!SelectorMapImpl.selectorScopesMatchNodeHierarchy(candidate, targetNode)) continue;
            results.add(candidate);
        }
        return results;
    }

    private static boolean selectorScopesMatchNodeHierarchy(SelectorImpl candidate, InternalNode targetNode) {
        if (candidate.getDepth() != null && candidate.getDepth().intValue() != targetNode.getDepth()) {
            return false;
        }
        if (candidate.getScopes().isEmpty()) {
            return true;
        }
        ArrayDeque<Scope> deq = new ArrayDeque<Scope>(candidate.getScopes());
        ScopeImpl scope = (ScopeImpl)deq.removeLast();
        for (InternalNode node = targetNode; node != null; node = node.getParent()) {
            if (scope.getDepth() == null || node.getDepth() >= scope.getDepth()) {
                if (scope.isFieldScope()) {
                    if (scope.resolveField().equals(node.getField())) {
                        scope = (ScopeImpl)deq.pollLast();
                    }
                } else if (node.getRawType().equals(scope.getTargetClass()) || node.getTargetClass().equals(scope.getTargetClass())) {
                    scope = (ScopeImpl)deq.pollLast();
                }
            }
            if (scope != null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.selectors.isEmpty()) {
            return "SelectorMap{}";
        }
        return String.format("SelectorMap:{%n%s%n}", this.selectors.entrySet().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator())));
    }

    private static final class PredicateSelectorEntry<V> {
        private final PredicateSelectorImpl predicateSelector;
        private final V value;
        private boolean matched;

        private PredicateSelectorEntry(PredicateSelectorImpl predicateSelector, V value) {
            this.predicateSelector = predicateSelector;
            this.value = value;
        }
    }

    private static final class EmptyMap<V>
    implements SelectorMap<V> {
        private EmptyMap() {
        }

        @Override
        public void put(TargetSelector targetSelector, V value) {
            throw new UnsupportedOperationException("Unmodifiable SelectorMap");
        }

        @Override
        public void forEach(BiConsumer<TargetSelector, V> action) {
        }

        @Override
        public Set<TargetSelector> getUnusedKeys() {
            return Collections.emptySet();
        }

        @Override
        public Optional<V> getValue(InternalNode node) {
            return Optional.empty();
        }

        @Override
        public List<V> getValues(InternalNode node) {
            return Collections.emptyList();
        }

        @Override
        public Set<TargetSelector> getSelectors(InternalNode node) {
            return Collections.emptySet();
        }
    }
}

